/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.config;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;

public class ClientboundCustomReportDetailsPacket
implements MinecraftPacket {
    private Map<String, String> details;

    public ClientboundCustomReportDetailsPacket() {
    }

    public ClientboundCustomReportDetailsPacket(Map<String, String> details) {
        this.details = details;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        int detailsCount = ProtocolUtils.readVarInt(buf);
        this.details = new HashMap<String, String>(detailsCount);
        for (int i = 0; i < detailsCount; ++i) {
            this.details.put(ProtocolUtils.readString(buf), ProtocolUtils.readString(buf));
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeVarInt(buf, this.details.size());
        this.details.forEach((key, detail) -> {
            ProtocolUtils.writeString(buf, key);
            ProtocolUtils.writeString(buf, detail);
        });
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public Map<String, String> getDetails() {
        return this.details;
    }
}

