/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.plugin.ap;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.plugin.Plugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SerializedPluginDescription {
    public static final String ID_PATTERN_STRING = "[a-z][a-z0-9-_]{0,63}";
    public static final Pattern ID_PATTERN = Pattern.compile("[a-z][a-z0-9-_]{0,63}");
    private final String id;
    private final @Nullable String name;
    private final @Nullable String version;
    private final @Nullable String description;
    private final @Nullable String url;
    private final @Nullable List<String> authors;
    private final @Nullable List<Dependency> dependencies;
    private final String main;

    private SerializedPluginDescription(String id, String name, String version, String description, String url, List<String> authors, List<Dependency> dependencies, String main) {
        Preconditions.checkNotNull(id, "id");
        Preconditions.checkArgument(ID_PATTERN.matcher(id).matches(), "id is not valid");
        this.id = id;
        this.name = Strings.emptyToNull(name);
        this.version = Strings.emptyToNull(version);
        this.description = Strings.emptyToNull(description);
        this.url = Strings.emptyToNull(url);
        this.authors = authors == null || authors.isEmpty() ? ImmutableList.of() : authors;
        this.dependencies = dependencies == null || dependencies.isEmpty() ? ImmutableList.of() : dependencies;
        this.main = Preconditions.checkNotNull(main, "main");
    }

    static SerializedPluginDescription from(Plugin plugin, String qualifiedName) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (com.velocitypowered.api.plugin.Dependency dependency : plugin.dependencies()) {
            dependencies.add(new Dependency(dependency.id(), dependency.optional()));
        }
        return new SerializedPluginDescription(plugin.id(), plugin.name(), plugin.version(), plugin.description(), plugin.url(), Arrays.stream(plugin.authors()).filter(author -> !author.isEmpty()).collect(Collectors.toList()), dependencies, qualifiedName);
    }

    public String getId() {
        return this.id;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public @Nullable String getVersion() {
        return this.version;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public @Nullable String getUrl() {
        return this.url;
    }

    public List<String> getAuthors() {
        return this.authors == null ? ImmutableList.of() : this.authors;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies == null ? ImmutableList.of() : this.dependencies;
    }

    public String getMain() {
        return this.main;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializedPluginDescription that = (SerializedPluginDescription)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.description, that.description) && Objects.equals(this.url, that.url) && Objects.equals(this.authors, that.authors) && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.main, that.main);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.version, this.description, this.url, this.authors, this.dependencies);
    }

    public String toString() {
        return "SerializedPluginDescription{id='" + this.id + "', name='" + this.name + "', version='" + this.version + "', description='" + this.description + "', url='" + this.url + "', authors=" + String.valueOf(this.authors) + ", dependencies=" + String.valueOf(this.dependencies) + ", main='" + this.main + "'}";
    }

    public static final class Dependency {
        private final String id;
        private final boolean optional;

        public Dependency(String id, boolean optional) {
            this.id = id;
            this.optional = optional;
        }

        public String getId() {
            return this.id;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Dependency that = (Dependency)o;
            return this.optional == that.optional && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.optional);
        }

        public String toString() {
            return "Dependency{id='" + this.id + "', optional=" + this.optional + "}";
        }
    }
}

