/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection;

import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jspecify.annotations.Nullable;

public final class PlayerDataForwarding {
    private static final String ALGORITHM = "HmacSHA256";
    public static final String CHANNEL = "velocity:player_info";
    public static final int MODERN_DEFAULT = 1;
    public static final int MODERN_WITH_KEY = 2;
    public static final int MODERN_WITH_KEY_V2 = 3;
    public static final int MODERN_LAZY_SESSION = 4;
    public static final int MODERN_MAX_VERSION = 4;
    private static final char LEGACY_SEPARATOR = '\u0000';
    private static final String BUNGEE_GUARD_TOKEN_PROPERTY_NAME = "bungeeguard-token";

    private PlayerDataForwarding() {
    }

    public static ByteBuf createForwardingData(byte[] secret, String address, ProtocolVersion protocol, GameProfile profile, @Nullable IdentifiedKey key, int requestedVersion) {
        ByteBuf forwarded = Unpooled.buffer(2048);
        try {
            int actualVersion = PlayerDataForwarding.findForwardingVersion(requestedVersion, protocol, key);
            ProtocolUtils.writeVarInt(forwarded, actualVersion);
            ProtocolUtils.writeString(forwarded, address);
            ProtocolUtils.writeUuid(forwarded, profile.getId());
            ProtocolUtils.writeString(forwarded, profile.getName());
            ProtocolUtils.writeProperties(forwarded, profile.getProperties());
            if (actualVersion >= 2 && actualVersion < 4) {
                assert (key != null);
                ProtocolUtils.writePlayerKey(forwarded, key);
                if (actualVersion >= 3) {
                    if (key.getSignatureHolder() != null) {
                        forwarded.writeBoolean(true);
                        ProtocolUtils.writeUuid(forwarded, key.getSignatureHolder());
                    } else {
                        forwarded.writeBoolean(false);
                    }
                }
            }
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(new SecretKeySpec(secret, ALGORITHM));
            mac.update(forwarded.array(), forwarded.arrayOffset(), forwarded.readableBytes());
            byte[] sig = mac.doFinal();
            return Unpooled.wrappedBuffer(Unpooled.wrappedBuffer(sig), forwarded);
        }
        catch (InvalidKeyException e) {
            forwarded.release();
            throw new RuntimeException("Unable to authenticate data", e);
        }
        catch (NoSuchAlgorithmException e) {
            forwarded.release();
            throw new AssertionError((Object)e);
        }
    }

    private static int findForwardingVersion(int requested, ProtocolVersion protocol, @Nullable IdentifiedKey key) {
        if ((requested = Math.min(requested, 4)) > 1) {
            if (protocol.noLessThan(ProtocolVersion.MINECRAFT_1_19_3)) {
                return requested >= 4 ? 4 : 1;
            }
            if (key != null) {
                return switch (key.getKeyRevision()) {
                    default -> throw new MatchException(null, null);
                    case IdentifiedKey.Revision.GENERIC_V1 -> 2;
                    case IdentifiedKey.Revision.LINKED_V2 -> requested >= 3 ? 3 : 1;
                };
            }
            return 1;
        }
        return 1;
    }

    public static String createLegacyForwardingAddress(String serverAddress, String playerAddress, GameProfile profile) {
        return PlayerDataForwarding.createLegacyForwardingAddress(serverAddress, playerAddress, profile, UnaryOperator.identity());
    }

    private static String createLegacyForwardingAddress(String serverAddress, String playerAddress, GameProfile profile, UnaryOperator<List<GameProfile.Property>> propertiesTransform) {
        StringBuilder data = new StringBuilder().append(serverAddress).append('\u0000').append(playerAddress).append('\u0000').append(profile.getUndashedId()).append('\u0000');
        VelocityServer.GENERAL_GSON.toJson(propertiesTransform.apply(profile.getProperties()), (Appendable)data);
        return data.toString();
    }

    public static String createBungeeGuardForwardingAddress(String serverAddress, String playerAddress, GameProfile profile, byte[] forwardingSecret) {
        GameProfile.Property property = new GameProfile.Property(BUNGEE_GUARD_TOKEN_PROPERTY_NAME, new String(forwardingSecret, StandardCharsets.UTF_8), "");
        return PlayerDataForwarding.createLegacyForwardingAddress(serverAddress, playerAddress, profile, properties -> ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)properties)).add(property)).build());
    }
}

