/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.crypto;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.proxy.crypto.KeySigned;
import com.velocitypowered.proxy.crypto.SignaturePair;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SignedChatCommand
implements KeySigned {
    private final String command;
    private final PublicKey signer;
    private final Instant expiry;
    private final byte[] salt;
    private final UUID sender;
    private final boolean isPreviewSigned;
    private final Map<String, byte[]> signatures;
    private final SignaturePair[] previousSignatures;
    private final @Nullable SignaturePair lastSignature;

    public SignedChatCommand(String command, PublicKey signer, UUID sender, Instant expiry, Map<String, byte[]> signature, byte[] salt, boolean isPreviewSigned, SignaturePair[] previousSignatures, @Nullable SignaturePair lastSignature) {
        this.command = Preconditions.checkNotNull(command);
        this.signer = Preconditions.checkNotNull(signer);
        this.sender = Preconditions.checkNotNull(sender);
        this.signatures = Preconditions.checkNotNull(signature);
        this.expiry = Preconditions.checkNotNull(expiry);
        this.salt = Preconditions.checkNotNull(salt);
        this.isPreviewSigned = isPreviewSigned;
        this.previousSignatures = previousSignatures;
        this.lastSignature = lastSignature;
    }

    @Override
    public PublicKey getSigner() {
        return this.signer;
    }

    @Override
    public Instant getExpiryTemporal() {
        return this.expiry;
    }

    @Override
    public @Nullable byte[] getSignature() {
        return null;
    }

    @Override
    public byte[] getSalt() {
        return this.salt;
    }

    public String getBaseCommand() {
        return this.command;
    }

    public Map<String, byte[]> getSignatures() {
        return this.signatures;
    }

    public boolean isPreviewSigned() {
        return this.isPreviewSigned;
    }

    public SignaturePair getLastSignature() {
        return this.lastSignature;
    }

    public SignaturePair[] getPreviousSignatures() {
        return this.previousSignatures;
    }
}

