/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.plugin.loader;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.plugin.meta.PluginDependency;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VelocityPluginDescription
implements PluginDescription {
    private final String id;
    private final @Nullable String name;
    private final @Nullable String version;
    private final @Nullable String description;
    private final @Nullable String url;
    private final List<String> authors;
    private final Map<String, PluginDependency> dependencies;
    private final Path source;

    public VelocityPluginDescription(String id, @Nullable String name, @Nullable String version, @Nullable String description, @Nullable String url, @Nullable List<String> authors, Collection<PluginDependency> dependencies, Path source) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = Strings.emptyToNull(name);
        this.version = Strings.emptyToNull(version);
        this.description = Strings.emptyToNull(description);
        this.url = Strings.emptyToNull(url);
        this.authors = authors == null ? ImmutableList.of() : ImmutableList.copyOf(authors);
        this.dependencies = Maps.uniqueIndex(dependencies, d -> d == null ? null : d.getId());
        this.source = source;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    public Optional<String> getUrl() {
        return Optional.ofNullable(this.url);
    }

    @Override
    public List<String> getAuthors() {
        return this.authors;
    }

    @Override
    public Collection<PluginDependency> getDependencies() {
        return this.dependencies.values();
    }

    @Override
    public Optional<PluginDependency> getDependency(String id) {
        return Optional.ofNullable(this.dependencies.get(id));
    }

    @Override
    public Optional<Path> getSource() {
        return Optional.ofNullable(this.source);
    }

    public String toString() {
        return "VelocityPluginDescription{id='" + this.id + "', name='" + this.name + "', version='" + this.version + "', description='" + this.description + "', url='" + this.url + "', authors=" + String.valueOf(this.authors) + ", dependencies=" + String.valueOf(this.dependencies) + ", source=" + String.valueOf(this.source) + "}";
    }
}

