/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.legacy;

import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.chat.RateLimitedCommandHandler;
import com.velocitypowered.proxy.protocol.packet.chat.legacy.LegacyChatPacket;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;

public class LegacyCommandHandler
extends RateLimitedCommandHandler<LegacyChatPacket> {
    private final ConnectedPlayer player;
    private final VelocityServer server;

    public LegacyCommandHandler(ConnectedPlayer player, VelocityServer server) {
        super(player, server);
        this.player = player;
        this.server = server;
    }

    @Override
    public Class<LegacyChatPacket> packetClass() {
        return LegacyChatPacket.class;
    }

    @Override
    public void handlePlayerCommandInternal(LegacyChatPacket packet) {
        String command = packet.getMessage().substring(1);
        this.queueCommandResult(this.server, this.player, (event, newLastSeenMessages) -> {
            CommandExecuteEvent.CommandResult result = event.getResult();
            if (result == CommandExecuteEvent.CommandResult.denied()) {
                return CompletableFuture.completedFuture(null);
            }
            String commandToRun = result.getCommand().orElse(command);
            if (result.isForwardToServer()) {
                return CompletableFuture.completedFuture(this.player.getChatBuilderFactory().builder().message("/" + commandToRun).toServer());
            }
            return this.runCommand(this.server, this.player, commandToRun, hasRun -> {
                if (!hasRun.booleanValue()) {
                    return this.player.getChatBuilderFactory().builder().message(packet.getMessage()).asPlayer(this.player).toServer();
                }
                return null;
            });
        }, command, Instant.now(), null, new CommandExecuteEvent.InvocationInfo(CommandExecuteEvent.SignedState.UNSUPPORTED, CommandExecuteEvent.Source.PLAYER));
    }
}

