/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.velocitypowered.proxy.command.VelocityCommands;
import com.velocitypowered.proxy.command.brigadier.VelocityArgumentCommandNode;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CommandGraphInjector<S> {
    private static final StringRange ALIAS_RANGE = StringRange.at(0);
    private static final StringReader ALIAS_READER = new StringReader("");
    private final @GuardedBy(value={"lock"}) CommandDispatcher<S> dispatcher;
    private final Lock lock;

    CommandGraphInjector(CommandDispatcher<S> dispatcher, Lock lock) {
        this.dispatcher = Preconditions.checkNotNull(dispatcher, "dispatcher");
        this.lock = Preconditions.checkNotNull(lock, "lock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inject(RootCommandNode<S> dest, S source) {
        this.lock.lock();
        try {
            IdentityHashMap<CommandNode<S>, CommandNode<S>> done = new IdentityHashMap<CommandNode<S>, CommandNode<S>>();
            RootCommandNode<S> origin = this.dispatcher.getRoot();
            CommandContextBuilder<S> rootContext = new CommandContextBuilder<S>(this.dispatcher, source, origin, 0);
            for (CommandNode<S> node : origin.getChildren()) {
                CommandContextBuilder<S> context;
                if (!node.canUse(source) || !node.canUse(context = rootContext.copy().withNode(node, ALIAS_RANGE), ALIAS_READER)) continue;
                LiteralCommandNode asLiteral = (LiteralCommandNode)node;
                CommandNode copy = ((LiteralArgumentBuilder)asLiteral.createBuilder()).build();
                VelocityArgumentCommandNode argsNode = VelocityCommands.getArgumentsNode(asLiteral);
                if (argsNode == null) {
                    this.copyChildren(node, copy, source, done);
                } else {
                    for (CommandNode child : node.getChildren()) {
                        copy.addChild(child);
                    }
                }
                this.addAlias((LiteralCommandNode<S>)copy, dest);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private @Nullable CommandNode<S> filterNode(CommandNode<S> node, S source, Map<CommandNode<S>, CommandNode<S>> done) {
        if (done.containsKey(node)) {
            return done.get(node);
        }
        if (!node.canUse(source)) {
            return null;
        }
        ArgumentBuilder<S, ?> builder = node.createBuilder();
        if (node.getRedirect() != null) {
            CommandNode<S> target = this.filterNode(node.getRedirect(), source, done);
            builder.forward(target, builder.getRedirectModifier(), builder.isFork());
        }
        CommandNode<S> result = builder.build();
        done.put(node, result);
        this.copyChildren(node, result, source, done);
        return result;
    }

    private void copyChildren(CommandNode<S> parent, CommandNode<S> dest, S source, Map<CommandNode<S>, CommandNode<S>> done) {
        for (CommandNode<S> child : parent.getChildren()) {
            CommandNode<S> filtered = this.filterNode(child, source, done);
            if (filtered == null) continue;
            dest.addChild(filtered);
        }
    }

    private void addAlias(LiteralCommandNode<S> node, RootCommandNode<S> dest) {
        dest.removeChildByName(node.getName());
        dest.addChild(node);
    }
}

