/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command.brigadier;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class VelocityArgumentCommandNode<S, T>
extends ArgumentCommandNode<S, String> {
    private final ArgumentType<T> type;

    VelocityArgumentCommandNode(String name, ArgumentType<T> type, Command<S> command, Predicate<S> requirement, BiPredicate<CommandContextBuilder<S>, ImmutableStringReader> contextRequirement, CommandNode<S> redirect, RedirectModifier<S> modifier, boolean forks, SuggestionProvider<S> customSuggestions) {
        super(name, StringArgumentType.greedyString(), command, requirement, contextRequirement, redirect, modifier, forks, customSuggestions);
        this.type = Preconditions.checkNotNull(type, "type");
    }

    @Override
    public void parse(StringReader reader, CommandContextBuilder<S> contextBuilder) throws CommandSyntaxException {
        int start = reader.getCursor();
        T result = this.type.parse(reader);
        if (reader.canRead()) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext(reader, "Expected greedy ArgumentType to parse all input");
        }
        ParsedArgument parsed = new ParsedArgument(start, reader.getCursor(), result);
        contextBuilder.withArgument(this.getName(), parsed);
        contextBuilder.withNode(this, parsed.getRange());
    }

    @Override
    public CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        if (this.getCustomSuggestions() == null) {
            return Suggestions.empty();
        }
        return this.getCustomSuggestions().getSuggestions(context, builder);
    }

    @Override
    public RequiredArgumentBuilder<S, String> createBuilder() {
        throw new UnsupportedOperationException();
    }

    public VelocityArgumentCommandNode<S, T> withCommand(Command<S> command) {
        return new VelocityArgumentCommandNode<S, T>(this.getName(), this.type, command, this.getRequirement(), this.getContextRequirement(), this.getRedirect(), this.getRedirectModifier(), this.isFork(), this.getCustomSuggestions());
    }

    public VelocityArgumentCommandNode<S, T> withRedirect(CommandNode<S> target) {
        return new VelocityArgumentCommandNode(this.getName(), this.type, this.getCommand(), this.getRequirement(), this.getContextRequirement(), target, this.getRedirectModifier(), this.isFork(), this.getCustomSuggestions());
    }

    @Override
    public boolean isValidInput(String input) {
        return true;
    }

    @Override
    public void addChild(CommandNode<S> node) {
        throw new UnsupportedOperationException("Cannot add children to a greedy node");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VelocityArgumentCommandNode)) {
            return false;
        }
        VelocityArgumentCommandNode that = (VelocityArgumentCommandNode)o;
        if (!super.equals(that)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    @Override
    public Collection<String> getExamples() {
        return this.type.getExamples();
    }

    @Override
    public String toString() {
        return "<argument " + this.getName() + ":" + String.valueOf(this.type) + ">";
    }
}

