/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command.builtin;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.permission.Tristate;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.proxy.command.builtin.BuiltinCommandUtil;
import com.velocitypowered.proxy.command.builtin.CommandMessages;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.translation.Argument;

public final class ServerCommand {
    private static final String SERVER_ARG = "server";
    public static final int MAX_SERVERS_TO_LIST = 50;

    public static BrigadierCommand create(ProxyServer server) {
        CommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder(SERVER_ARG).requires(src -> src instanceof Player && src.getPermissionValue("velocity.command.server") != Tristate.FALSE)).executes(ctx -> {
            Player player = (Player)ctx.getSource();
            ServerCommand.outputServerInformation(player, server);
            return 1;
        })).then(BrigadierCommand.requiredArgumentBuilder(SERVER_ARG, StringArgumentType.word()).suggests((ctx, builder) -> {
            String argument = ctx.getArguments().containsKey(SERVER_ARG) ? StringArgumentType.getString(ctx, SERVER_ARG) : "";
            for (RegisteredServer sv : server.getAllServers()) {
                String serverName = sv.getServerInfo().getName();
                if (!serverName.regionMatches(true, 0, argument, 0, argument.length())) continue;
                builder.suggest(serverName);
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            Player player = (Player)ctx.getSource();
            String serverName = StringArgumentType.getString(ctx, SERVER_ARG);
            Optional<RegisteredServer> toConnect = server.getServer(serverName);
            if (toConnect.isEmpty()) {
                player.sendMessage(CommandMessages.SERVER_DOES_NOT_EXIST.arguments(Argument.string(SERVER_ARG, serverName)));
                return -1;
            }
            player.createConnectionRequest(toConnect.get()).fireAndForget();
            return 1;
        }))).build();
        return new BrigadierCommand((LiteralCommandNode<CommandSource>)node);
    }

    private static void outputServerInformation(Player executor, ProxyServer server) {
        String currentServer = executor.getCurrentServer().map(ServerConnection::getServerInfo).map(ServerInfo::getName).orElse("<unknown>");
        executor.sendMessage(Component.translatable("velocity.command.server-current-server", (TextColor)NamedTextColor.YELLOW, Component.text(currentServer)));
        List<RegisteredServer> servers = BuiltinCommandUtil.sortedServerList(server);
        if (servers.size() > 50) {
            executor.sendMessage(Component.translatable("velocity.command.server-too-many", (TextColor)NamedTextColor.RED));
            return;
        }
        TextComponent.Builder serverListBuilder = (TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.translatable("velocity.command.server-available", (TextColor)NamedTextColor.YELLOW))).appendSpace();
        for (int i = 0; i < servers.size(); ++i) {
            RegisteredServer rs = servers.get(i);
            serverListBuilder.append((Component)ServerCommand.formatServerComponent(currentServer, rs));
            if (i == servers.size() - 1) continue;
            serverListBuilder.append((Component)Component.text(", ", (TextColor)NamedTextColor.GRAY));
        }
        executor.sendMessage((Component)serverListBuilder.build());
    }

    private static TextComponent formatServerComponent(String currentPlayerServer, RegisteredServer server) {
        ServerInfo serverInfo = server.getServerInfo();
        TextComponent.Builder serverTextComponent = Component.text().content(serverInfo.getName());
        int connectedPlayers = server.getPlayersConnected().size();
        TranslatableComponent.Builder playersTextComponent = Component.translatable();
        if (connectedPlayers == 1) {
            playersTextComponent.key("velocity.command.server-tooltip-player-online");
        } else {
            playersTextComponent.key("velocity.command.server-tooltip-players-online");
        }
        playersTextComponent.arguments(Argument.component("players", Component.text(connectedPlayers)));
        if (serverInfo.getName().equals(currentPlayerServer)) {
            ((TextComponent.Builder)serverTextComponent.color(NamedTextColor.GREEN)).hoverEvent(HoverEvent.showText(((TranslatableComponent)Component.translatable("velocity.command.server-tooltip-current-server").append(Component.newline())).append(playersTextComponent)));
        } else {
            ((TextComponent.Builder)((TextComponent.Builder)serverTextComponent.color(NamedTextColor.GRAY)).clickEvent(ClickEvent.runCommand("/server " + serverInfo.getName()))).hoverEvent(HoverEvent.showText(((TranslatableComponent)Component.translatable("velocity.command.server-tooltip-offer-connect-server").append(Component.newline())).append(playersTextComponent)));
        }
        return (TextComponent)serverTextComponent.build();
    }
}

