/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.config.migration;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.velocitypowered.proxy.config.migration.ConfigurationMigration;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.apache.logging.log4j.Logger;

public final class MiniMessageTranslationsMigration
implements ConfigurationMigration {
    @Override
    public boolean shouldMigrate(CommentedFileConfig config) {
        return true;
    }

    @Override
    public void migrate(CommentedFileConfig config, Logger logger) throws IOException {
        Path langFolder = Path.of("lang", new String[0]);
        if (Files.notExists(langFolder, new LinkOption[0])) {
            return;
        }
        Pattern oldPlaceholderPattern = Pattern.compile("\\{(\\d+)}");
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(langFolder, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
            for (Path path : stream) {
                String content = Files.readString(path, StandardCharsets.UTF_8);
                if (content.indexOf(123) == -1) continue;
                content = oldPlaceholderPattern.matcher(content).replaceAll("<arg:$1>");
                content = (String)MiniMessage.miniMessage().serialize(LegacyComponentSerializer.legacySection().deserialize(content));
                Files.writeString(path, (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }
    }
}

