/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.backend;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.HandshakeIntent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.PluginMessageEncoder;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.config.PlayerInfoForwarding;
import com.velocitypowered.proxy.connection.ConnectionType;
import com.velocitypowered.proxy.connection.ConnectionTypes;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftConnectionAssociation;
import com.velocitypowered.proxy.connection.PlayerDataForwarding;
import com.velocitypowered.proxy.connection.backend.BackendConnectionPhase;
import com.velocitypowered.proxy.connection.backend.BackendConnectionPhases;
import com.velocitypowered.proxy.connection.backend.LoginSessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.forge.modern.ModernForgeConnectionType;
import com.velocitypowered.proxy.connection.util.ConnectionRequestResults;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.HandshakePacket;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import com.velocitypowered.proxy.protocol.packet.ServerLoginPacket;
import com.velocitypowered.proxy.protocol.util.ByteBufDataOutput;
import com.velocitypowered.proxy.server.VelocityRegisteredServer;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class VelocityServerConnection
implements MinecraftConnectionAssociation,
ServerConnection {
    private final VelocityRegisteredServer registeredServer;
    private final @Nullable VelocityRegisteredServer previousServer;
    private final ConnectedPlayer proxyPlayer;
    private final VelocityServer server;
    private @Nullable MinecraftConnection connection;
    private boolean hasCompletedJoin = false;
    private boolean gracefulDisconnect = false;
    private BackendConnectionPhase connectionPhase = BackendConnectionPhases.UNKNOWN;
    private final Map<Long, Long> pendingPings = new HashMap<Long, Long>();
    private @MonotonicNonNull Integer entityId;

    public VelocityServerConnection(VelocityRegisteredServer registeredServer, @Nullable VelocityRegisteredServer previousServer, ConnectedPlayer proxyPlayer, VelocityServer server) {
        this.registeredServer = registeredServer;
        this.previousServer = previousServer;
        this.proxyPlayer = proxyPlayer;
        this.server = server;
    }

    public CompletableFuture<ConnectionRequestResults.Impl> connect() {
        CompletableFuture<ConnectionRequestResults.Impl> result = new CompletableFuture<ConnectionRequestResults.Impl>();
        ((Bootstrap)this.server.createBootstrap(this.proxyPlayer.getConnection().eventLoop()).handler(this.server.getBackendChannelInitializer())).connect(this.registeredServer.getServerInfo().getAddress()).addListener(future -> {
            if (future.isSuccess()) {
                this.connection = new MinecraftConnection(future.channel(), this.server);
                this.connection.setAssociation(this);
                future.channel().pipeline().addLast("handler", (ChannelHandler)this.connection);
                if (!this.connection.setActiveSessionHandler(StateRegistry.HANDSHAKE)) {
                    LoginSessionHandler handler = new LoginSessionHandler(this.server, this, result);
                    this.connection.setActiveSessionHandler(StateRegistry.HANDSHAKE, handler);
                    this.connection.addSessionHandler(StateRegistry.LOGIN, handler);
                }
                this.connectionPhase = this.connection.getType().getInitialBackendPhase();
                this.startHandshake();
            } else {
                result.completeExceptionally(future.cause());
            }
        });
        return result;
    }

    String getPlayerRemoteAddressAsString() {
        String addr = this.proxyPlayer.getRemoteAddress().getAddress().getHostAddress();
        int ipv6ScopeIdx = addr.indexOf(37);
        if (ipv6ScopeIdx == -1) {
            return addr;
        }
        return addr.substring(0, ipv6ScopeIdx);
    }

    private String createLegacyForwardingAddress() {
        return PlayerDataForwarding.createLegacyForwardingAddress(this.proxyPlayer.getVirtualHost().orElseGet(() -> this.registeredServer.getServerInfo().getAddress()).getHostString(), this.getPlayerRemoteAddressAsString(), this.proxyPlayer.getGameProfile());
    }

    private String createBungeeGuardForwardingAddress(byte[] forwardingSecret) {
        return PlayerDataForwarding.createBungeeGuardForwardingAddress(this.proxyPlayer.getVirtualHost().orElseGet(() -> this.registeredServer.getServerInfo().getAddress()).getHostString(), this.getPlayerRemoteAddressAsString(), this.proxyPlayer.getGameProfile(), forwardingSecret);
    }

    private void startHandshake() {
        MinecraftConnection mc = this.ensureConnected();
        PlayerInfoForwarding forwardingMode = this.server.getConfiguration().getPlayerInfoForwardingMode();
        ProtocolVersion protocolVersion = this.proxyPlayer.getConnection().getProtocolVersion();
        String playerVhost = this.proxyPlayer.getVirtualHost().orElseGet(() -> this.registeredServer.getServerInfo().getAddress()).getHostString();
        HandshakePacket handshake = new HandshakePacket();
        handshake.setIntent(HandshakeIntent.LOGIN);
        handshake.setProtocolVersion(protocolVersion);
        if (forwardingMode == PlayerInfoForwarding.LEGACY) {
            handshake.setServerAddress(this.createLegacyForwardingAddress());
        } else if (forwardingMode == PlayerInfoForwarding.BUNGEEGUARD) {
            byte[] secret = this.server.getConfiguration().getForwardingSecret();
            handshake.setServerAddress(this.createBungeeGuardForwardingAddress(secret));
        } else if (this.proxyPlayer.getConnection().getType() == ConnectionTypes.LEGACY_FORGE) {
            handshake.setServerAddress(playerVhost + "\u0000FML\u0000");
        } else {
            ConnectionType connectionType = this.proxyPlayer.getConnection().getType();
            if (connectionType instanceof ModernForgeConnectionType) {
                ModernForgeConnectionType forgeConnection = (ModernForgeConnectionType)connectionType;
                handshake.setServerAddress(playerVhost + forgeConnection.getModernToken());
            } else {
                handshake.setServerAddress(playerVhost);
            }
        }
        handshake.setPort(this.proxyPlayer.getVirtualHost().orElseGet(() -> this.registeredServer.getServerInfo().getAddress()).getPort());
        mc.delayedWrite(handshake);
        mc.setProtocolVersion(protocolVersion);
        mc.setActiveSessionHandler(StateRegistry.LOGIN);
        if (this.proxyPlayer.getIdentifiedKey() == null && this.proxyPlayer.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_19_3)) {
            mc.delayedWrite(new ServerLoginPacket(this.proxyPlayer.getUsername(), this.proxyPlayer.getUniqueId()));
        } else {
            mc.delayedWrite(new ServerLoginPacket(this.proxyPlayer.getUsername(), this.proxyPlayer.getIdentifiedKey()));
        }
        mc.flush();
    }

    public @Nullable MinecraftConnection getConnection() {
        return this.connection;
    }

    public MinecraftConnection ensureConnected() {
        if (this.connection == null) {
            throw new IllegalStateException("Not connected to server!");
        }
        return this.connection;
    }

    @Override
    public VelocityRegisteredServer getServer() {
        return this.registeredServer;
    }

    @Override
    public Optional<RegisteredServer> getPreviousServer() {
        return Optional.ofNullable(this.previousServer);
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.registeredServer.getServerInfo();
    }

    @Override
    public ConnectedPlayer getPlayer() {
        return this.proxyPlayer;
    }

    public void disconnect() {
        if (this.connection != null) {
            this.gracefulDisconnect = true;
            this.connection.close(false);
            this.connection = null;
        }
    }

    public String toString() {
        return "[server connection] " + this.proxyPlayer.getGameProfile().getName() + " -> " + this.registeredServer.getServerInfo().getName();
    }

    @Override
    public boolean sendPluginMessage(@NotNull ChannelIdentifier identifier, byte @NotNull [] data) {
        return this.sendPluginMessage(identifier, Unpooled.wrappedBuffer(data));
    }

    @Override
    public boolean sendPluginMessage(@NotNull ChannelIdentifier identifier, @NotNull PluginMessageEncoder dataEncoder) {
        Objects.requireNonNull(identifier);
        Objects.requireNonNull(dataEncoder);
        ByteBuf buf = Unpooled.buffer();
        ByteBufDataOutput dataOutput = new ByteBufDataOutput(buf);
        dataEncoder.encode(dataOutput);
        if (buf.isReadable()) {
            return this.sendPluginMessage(identifier, buf);
        }
        buf.release();
        return false;
    }

    public boolean sendPluginMessage(ChannelIdentifier identifier, ByteBuf data) {
        Preconditions.checkNotNull(identifier, "identifier");
        Preconditions.checkNotNull(data, "data");
        MinecraftConnection mc = this.ensureConnected();
        PluginMessagePacket message = new PluginMessagePacket(identifier.getId(), data);
        mc.write(message);
        return true;
    }

    public void completeJoin() {
        if (!this.hasCompletedJoin) {
            this.hasCompletedJoin = true;
            if (this.connectionPhase == BackendConnectionPhases.UNKNOWN) {
                this.connectionPhase = BackendConnectionPhases.VANILLA;
                if (this.connection != null) {
                    this.connection.setType(ConnectionTypes.VANILLA);
                }
            }
        }
    }

    boolean isGracefulDisconnect() {
        return this.gracefulDisconnect;
    }

    public Map<Long, Long> getPendingPings() {
        return this.pendingPings;
    }

    public Integer getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Integer entityId) {
        this.entityId = entityId;
    }

    public boolean isActive() {
        return this.connection != null && !this.connection.isClosed() && !this.gracefulDisconnect && this.proxyPlayer.isActive();
    }

    public BackendConnectionPhase getPhase() {
        return this.connectionPhase;
    }

    public void setConnectionPhase(BackendConnectionPhase connectionPhase) {
        this.connectionPhase = connectionPhase;
    }

    public boolean hasCompletedJoin() {
        return this.hasCompletedJoin;
    }
}

