/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.netty;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.ImmutableSet;
import com.velocitypowered.api.event.query.ProxyQueryEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.QueryResponse;
import com.velocitypowered.proxy.VelocityServer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.apache.logging.log4j.LogManager;

public class GameSpyQueryHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private static final short QUERY_MAGIC_FIRST = 254;
    private static final short QUERY_MAGIC_SECOND = 253;
    private static final byte QUERY_TYPE_HANDSHAKE = 9;
    private static final byte QUERY_TYPE_STAT = 0;
    private static final byte[] QUERY_RESPONSE_FULL_PADDING = new byte[]{115, 112, 108, 105, 116, 110, 117, 109, 0, -128, 0};
    private static final byte[] QUERY_RESPONSE_FULL_PADDING2 = new byte[]{1, 112, 108, 97, 121, 101, 114, 95, 0, 0};
    private static final ImmutableSet<String> QUERY_BASIC_RESPONSE_CONTENTS = ImmutableSet.of("hostname", "gametype", "map", "numplayers", "maxplayers", "hostport", new String[]{"hostip"});
    private final Cache<InetAddress, Integer> sessions = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private final SecureRandom random;
    private final VelocityServer server;

    public GameSpyQueryHandler(VelocityServer server) {
        this.server = server;
        this.random = new SecureRandom();
    }

    private QueryResponse createInitialResponse() {
        return QueryResponse.builder().hostname(PlainTextComponentSerializer.plainText().serialize(this.server.getConfiguration().getMotd())).gameVersion(ProtocolVersion.SUPPORTED_VERSION_STRING).map(this.server.getConfiguration().getQueryMap()).currentPlayers(this.server.getPlayerCount()).maxPlayers(this.server.getConfiguration().getShowMaxPlayers()).proxyPort(this.server.getConfiguration().getBind().getPort()).proxyHost(this.server.getConfiguration().getBind().getHostString()).players(this.server.getAllPlayers().stream().map(Player::getUsername).collect(Collectors.toList())).proxyVersion("Velocity").plugins(this.server.getConfiguration().shouldQueryShowPlugins() ? this.getRealPluginInformation() : Collections.emptyList()).build();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
        ByteBuf queryMessage = (ByteBuf)msg.content();
        InetAddress senderAddress = ((InetSocketAddress)msg.sender()).getAddress();
        if (queryMessage.readUnsignedByte() != 254 || queryMessage.readUnsignedByte() != 253) {
            return;
        }
        short type = queryMessage.readUnsignedByte();
        int sessionId = queryMessage.readInt();
        switch (type) {
            case 9: {
                int challengeToken = this.random.nextInt();
                this.sessions.put(senderAddress, challengeToken);
                ByteBuf queryResponse = ctx.alloc().buffer();
                queryResponse.writeByte(9);
                queryResponse.writeInt(sessionId);
                GameSpyQueryHandler.writeString(queryResponse, Integer.toString(challengeToken));
                DatagramPacket responsePacket = new DatagramPacket(queryResponse, (InetSocketAddress)msg.sender());
                ctx.writeAndFlush(responsePacket, ctx.voidPromise());
                break;
            }
            case 0: {
                int challengeToken = queryMessage.readInt();
                Integer session = this.sessions.getIfPresent(senderAddress);
                if (session == null || session != challengeToken) {
                    return;
                }
                if (queryMessage.readableBytes() != 0 && queryMessage.readableBytes() != 4) {
                    return;
                }
                QueryResponse response = this.createInitialResponse();
                boolean isBasic = !queryMessage.isReadable();
                ((CompletableFuture)this.server.getEventManager().fire(new ProxyQueryEvent(isBasic ? ProxyQueryEvent.QueryType.BASIC : ProxyQueryEvent.QueryType.FULL, senderAddress, response)).thenAcceptAsync(event -> {
                    ByteBuf queryResponse = ctx.alloc().buffer();
                    queryResponse.writeByte(0);
                    queryResponse.writeInt(sessionId);
                    ResponseWriter responseWriter = new ResponseWriter(queryResponse, isBasic);
                    responseWriter.write("hostname", event.getResponse().getHostname());
                    responseWriter.write("gametype", "SMP");
                    responseWriter.write("game_id", "MINECRAFT");
                    responseWriter.write("version", event.getResponse().getGameVersion());
                    responseWriter.writePlugins(event.getResponse().getProxyVersion(), event.getResponse().getPlugins());
                    responseWriter.write("map", event.getResponse().getMap());
                    responseWriter.write("numplayers", event.getResponse().getCurrentPlayers());
                    responseWriter.write("maxplayers", event.getResponse().getMaxPlayers());
                    responseWriter.write("hostport", event.getResponse().getProxyPort());
                    responseWriter.write("hostip", event.getResponse().getProxyHost());
                    if (!responseWriter.isBasic) {
                        responseWriter.writePlayers(event.getResponse().getPlayers());
                    }
                    DatagramPacket responsePacket = new DatagramPacket(queryResponse, (InetSocketAddress)msg.sender());
                    ctx.writeAndFlush(responsePacket, ctx.voidPromise());
                }, (Executor)ctx.channel().eventLoop())).exceptionally(ex -> {
                    LogManager.getLogger(this.getClass()).error("Exception while writing GS4 response for query from {}", (Object)senderAddress, ex);
                    return null;
                });
                break;
            }
        }
    }

    private static void writeString(ByteBuf buf, String string) {
        buf.writeCharSequence(string, StandardCharsets.ISO_8859_1);
        buf.writeByte(0);
    }

    private List<QueryResponse.PluginInformation> getRealPluginInformation() {
        ArrayList<QueryResponse.PluginInformation> result = new ArrayList<QueryResponse.PluginInformation>();
        for (PluginContainer plugin : this.server.getPluginManager().getPlugins()) {
            PluginDescription description = plugin.getDescription();
            result.add(QueryResponse.PluginInformation.of(description.getName().orElse(description.getId()), description.getVersion().orElse(null)));
        }
        return result;
    }

    private static class ResponseWriter {
        private final ByteBuf buf;
        private final boolean isBasic;

        ResponseWriter(ByteBuf buf, boolean isBasic) {
            this.buf = buf;
            this.isBasic = isBasic;
            if (!isBasic) {
                buf.writeBytes(QUERY_RESPONSE_FULL_PADDING);
            }
        }

        void write(String key, Object value) {
            if (this.isBasic) {
                if (!QUERY_BASIC_RESPONSE_CONTENTS.contains(key)) {
                    return;
                }
                if (key.equals("hostport")) {
                    this.buf.writeShortLE((Integer)value);
                } else {
                    GameSpyQueryHandler.writeString(this.buf, value.toString());
                }
            } else {
                GameSpyQueryHandler.writeString(this.buf, key);
                GameSpyQueryHandler.writeString(this.buf, value.toString());
            }
        }

        void writePlayers(Collection<String> players) {
            if (this.isBasic) {
                return;
            }
            this.buf.writeByte(0);
            this.buf.writeBytes(QUERY_RESPONSE_FULL_PADDING2);
            players.forEach(player -> GameSpyQueryHandler.writeString(this.buf, player));
            this.buf.writeByte(0);
        }

        void writePlugins(String serverVersion, Collection<QueryResponse.PluginInformation> plugins) {
            if (this.isBasic) {
                return;
            }
            StringBuilder pluginsString = new StringBuilder();
            pluginsString.append(serverVersion).append(':').append(' ');
            Iterator<QueryResponse.PluginInformation> iterator = plugins.iterator();
            while (iterator.hasNext()) {
                QueryResponse.PluginInformation info = iterator.next();
                pluginsString.append(info.getName());
                Optional<String> version = info.getVersion();
                version.ifPresent(s -> pluginsString.append(' ').append((String)s));
                if (!iterator.hasNext()) continue;
                pluginsString.append(';').append(' ');
            }
            this.write("plugins", pluginsString.toString());
        }
    }
}

