/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;

public class ClientboundStopSoundPacket
implements MinecraftPacket {
    @Nullable
    private Sound.Source source;
    @Nullable
    private Key soundName;

    public ClientboundStopSoundPacket() {
    }

    public ClientboundStopSoundPacket(SoundStop soundStop) {
        this(soundStop.source(), soundStop.sound());
    }

    public ClientboundStopSoundPacket(@Nullable Sound.Source source, @Nullable Key soundName) {
        this.source = source;
        this.soundName = soundName;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        byte flagsBitmask = buf.readByte();
        this.source = (flagsBitmask & 1) != 0 ? ProtocolUtils.readSoundSource(buf, protocolVersion) : null;
        this.soundName = (flagsBitmask & 2) != 0 ? ProtocolUtils.readKey(buf) : null;
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        int flagsBitmask = 0;
        if (this.source != null && this.soundName == null) {
            flagsBitmask |= 1;
        } else if (this.soundName != null && this.source == null) {
            flagsBitmask |= 2;
        } else if (this.source != null) {
            flagsBitmask |= 3;
        }
        buf.writeByte(flagsBitmask);
        if (this.source != null) {
            ProtocolUtils.writeSoundSource(buf, protocolVersion, this.source);
        }
        if (this.soundName != null) {
            ProtocolUtils.writeMinimalKey(buf, this.soundName);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    @Nullable
    public Sound.Source getSource() {
        return this.source;
    }

    public void setSource(@Nullable Sound.Source source) {
        this.source = source;
    }

    @Nullable
    public Key getSoundName() {
        return this.soundName;
    }

    public void setSoundName(@Nullable Key soundName) {
        this.soundName = soundName;
    }
}

