/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.session;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.LastSeenMessages;
import io.netty.buffer.ByteBuf;
import java.time.Instant;

public class SessionPlayerChatPacket
implements MinecraftPacket {
    protected String message;
    protected Instant timestamp;
    protected long salt;
    protected boolean signed;
    protected byte[] signature;
    protected LastSeenMessages lastSeenMessages;

    public String getMessage() {
        return this.message;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public LastSeenMessages getLastSeenMessages() {
        return this.lastSeenMessages;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        this.message = ProtocolUtils.readString(buf, 256);
        this.timestamp = Instant.ofEpochMilli(buf.readLong());
        this.salt = buf.readLong();
        this.signed = buf.readBoolean();
        this.signature = this.signed ? SessionPlayerChatPacket.readMessageSignature(buf) : new byte[0];
        this.lastSeenMessages = new LastSeenMessages(buf, protocolVersion);
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeString(buf, this.message);
        buf.writeLong(this.timestamp.toEpochMilli());
        buf.writeLong(this.salt);
        buf.writeBoolean(this.signed);
        if (this.signed) {
            buf.writeBytes(this.signature);
        }
        this.lastSeenMessages.encode(buf, protocolVersion);
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    protected static byte[] readMessageSignature(ByteBuf buf) {
        byte[] signature = new byte[256];
        buf.readBytes(signature);
        return signature;
    }

    public SessionPlayerChatPacket withLastSeenMessages(LastSeenMessages lastSeenMessages) {
        SessionPlayerChatPacket packet = new SessionPlayerChatPacket();
        packet.message = this.message;
        packet.timestamp = this.timestamp;
        packet.salt = this.salt;
        packet.signed = this.signed;
        packet.signature = this.signature;
        packet.lastSeenMessages = lastSeenMessages;
        return packet;
    }
}

