/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.velocitypowered.proxy.scheduler.SchedulerBackend;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ExecutorSchedulerBackend
implements SchedulerBackend {
    private final ScheduledExecutorService executor;

    public ExecutorSchedulerBackend() {
        this(Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Velocity Task Scheduler Timer").build()));
    }

    public ExecutorSchedulerBackend(ScheduledExecutorService executor) {
        this.executor = Preconditions.checkNotNull(executor, "executor");
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        return this.executor.schedule(task, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(task, initialDelay, period, unit);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }
}

