/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.plugin.meta.PluginDependency;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.config.ProxyConfig;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.util.ProxyVersion;
import com.velocitypowered.natives.util.Natives;
import com.velocitypowered.proxy.network.TransportType;
import java.lang.runtime.SwitchBootstraps;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class InformationUtils
extends Enum<InformationUtils> {
    private static final Gson GSON_WITH_EXCLUDES;
    private static final Gson GSON_WITHOUT_EXCLUDES;
    private static final /* synthetic */ InformationUtils[] $VALUES;

    public static InformationUtils[] values() {
        return (InformationUtils[])$VALUES.clone();
    }

    public static InformationUtils valueOf(String name) {
        return Enum.valueOf(InformationUtils.class, name);
    }

    public static JsonArray collectPluginInfo(ProxyServer proxy) {
        ImmutableList<PluginContainer> allPlugins = ImmutableList.copyOf(proxy.getPluginManager().getPlugins());
        JsonArray plugins = new JsonArray();
        for (PluginContainer plugin : allPlugins) {
            PluginDescription desc = plugin.getDescription();
            JsonObject current = new JsonObject();
            current.addProperty("id", desc.getId());
            if (desc.getName().isPresent()) {
                current.addProperty("name", desc.getName().get());
            }
            if (desc.getVersion().isPresent()) {
                current.addProperty("version", desc.getVersion().get());
            }
            if (!desc.getAuthors().isEmpty()) {
                JsonArray authorsArray = new JsonArray();
                for (String author : desc.getAuthors()) {
                    authorsArray.add(author);
                }
                current.add("authors", authorsArray);
            }
            if (desc.getDescription().isPresent()) {
                current.addProperty("description", desc.getDescription().get());
            }
            if (desc.getUrl().isPresent()) {
                current.addProperty("url", desc.getUrl().get());
            }
            if (!desc.getDependencies().isEmpty()) {
                JsonArray dependencies = new JsonArray();
                for (PluginDependency dependency : desc.getDependencies()) {
                    dependencies.add(dependency.getId());
                }
                current.add("dependencies", dependencies);
            }
            plugins.add(current);
        }
        return plugins;
    }

    public static JsonObject collectEnvironmentInfo() {
        JsonObject envInfo = new JsonObject();
        envInfo.addProperty("operatingSystemType", System.getProperty("os.name"));
        envInfo.addProperty("operatingSystemVersion", System.getProperty("os.version"));
        envInfo.addProperty("operatingSystemArchitecture", System.getProperty("os.arch"));
        envInfo.addProperty("javaVersion", System.getProperty("java.version"));
        envInfo.addProperty("javaVendor", System.getProperty("java.vendor"));
        JsonObject listenerInfo = new JsonObject();
        listenerInfo.addProperty("listenerType", TransportType.bestType().toString());
        listenerInfo.addProperty("compression", Natives.compress.getLoadedVariant());
        listenerInfo.addProperty("encryption", Natives.cipher.getLoadedVariant());
        envInfo.add("listener", listenerInfo);
        return envInfo;
    }

    public static JsonObject collectForcedHosts(ProxyConfig config) {
        JsonObject forcedHosts = new JsonObject();
        ImmutableMap<String, List<String>> allForcedHosts = ImmutableMap.copyOf(config.getForcedHosts());
        for (Map.Entry entry : allForcedHosts.entrySet()) {
            JsonArray host = new JsonArray();
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                host.add((String)((List)entry.getValue()).get(i));
            }
            forcedHosts.add((String)entry.getKey(), host);
        }
        return forcedHosts;
    }

    public static String anonymizeInetAddress(InetAddress address) {
        InetAddress inetAddress = address;
        Objects.requireNonNull(inetAddress);
        InetAddress inetAddress2 = inetAddress;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Inet4Address.class, Inet6Address.class}, (Object)inetAddress2, n)) {
            case 0 -> {
                Inet4Address v4 = (Inet4Address)inetAddress2;
                if (v4.isAnyLocalAddress() || v4.isLoopbackAddress() || v4.isLinkLocalAddress() || v4.isSiteLocalAddress()) {
                    yield address.getHostAddress();
                }
                byte[] addr = v4.getAddress();
                yield (addr[0] & 0xFF) + "." + (addr[1] & 0xFF) + ".XXX.XXX";
            }
            case 1 -> {
                Inet6Address v6 = (Inet6Address)inetAddress2;
                if (v6.isAnyLocalAddress() || v6.isLoopbackAddress() || v6.isSiteLocalAddress() || v6.isSiteLocalAddress()) {
                    yield address.getHostAddress();
                }
                String[] bits = v6.getHostAddress().split(":");
                Object ret = "";
                boolean flag = false;
                for (int iter = 0; iter < bits.length; ++iter) {
                    if (flag) {
                        ret = (String)ret + ":X";
                        continue;
                    }
                    if (bits[iter].equals("0")) continue;
                    ret = iter == 0 ? bits[iter] : "::" + bits[iter];
                    flag = true;
                }
                yield ret;
            }
            default -> address.getHostAddress();
        };
    }

    public static JsonObject collectServerInfo(RegisteredServer server) {
        JsonObject info = new JsonObject();
        info.addProperty("currentPlayers", server.getPlayersConnected().size());
        InetSocketAddress iaddr = server.getServerInfo().getAddress();
        if (iaddr.isUnresolved()) {
            info.addProperty("host", iaddr.getHostString());
        } else {
            info.addProperty("host", InformationUtils.anonymizeInetAddress(iaddr.getAddress()));
        }
        info.addProperty("port", iaddr.getPort());
        return info;
    }

    public static JsonObject collectProxyInfo(ProxyVersion version) {
        return (JsonObject)InformationUtils.serializeObject(version, false);
    }

    public static JsonObject collectProxyConfig(ProxyConfig config) {
        return (JsonObject)InformationUtils.serializeObject(config, true);
    }

    public static String toHumanReadableString(JsonElement json) {
        return GSON_WITHOUT_EXCLUDES.toJson(json);
    }

    public static JsonObject parseString(String toParse) {
        return GSON_WITHOUT_EXCLUDES.fromJson(toParse, JsonObject.class);
    }

    private static JsonElement serializeObject(Object toSerialize, boolean withExcludes) {
        return JsonParser.parseString(withExcludes ? GSON_WITH_EXCLUDES.toJson(toSerialize) : GSON_WITHOUT_EXCLUDES.toJson(toSerialize));
    }

    private static /* synthetic */ InformationUtils[] $values() {
        return new InformationUtils[0];
    }

    static {
        $VALUES = InformationUtils.$values();
        GSON_WITH_EXCLUDES = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
        GSON_WITHOUT_EXCLUDES = new GsonBuilder().setPrettyPrinting().create();
    }
}

