/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.Limits;
import io.netty.channel.uring.Native;
import io.netty.channel.uring.RingBuffer;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;

public final class IoUring {
    private static final Throwable UNAVAILABILITY_CAUSE;
    private static final boolean IORING_CQE_F_SOCK_NONEMPTY_SUPPORTED;
    private static final boolean IORING_SPLICE_SUPPORTED;
    private static final boolean IORING_SEND_ZC_SUPPORTED;
    private static final boolean IORING_SENDMSG_ZC_SUPPORTED;
    private static final boolean IORING_ACCEPT_NO_WAIT_SUPPORTED;
    private static final boolean IORING_ACCEPT_MULTISHOT_SUPPORTED;
    private static final boolean IORING_RECV_MULTISHOT_SUPPORTED;
    private static final boolean IORING_RECVSEND_BUNDLE_SUPPORTED;
    private static final boolean IORING_POLL_ADD_MULTISHOT_SUPPORTED;
    private static final boolean IORING_REGISTER_IOWQ_MAX_WORKERS_SUPPORTED;
    private static final boolean IORING_SETUP_SUBMIT_ALL_SUPPORTED;
    private static final boolean IORING_SETUP_CQE_MIXED_SUPPORTED;
    private static final boolean IORING_SETUP_CQ_SIZE_SUPPORTED;
    private static final boolean IORING_SETUP_SINGLE_ISSUER_SUPPORTED;
    private static final boolean IORING_SETUP_DEFER_TASKRUN_SUPPORTED;
    private static final boolean IORING_SETUP_NO_SQARRAY_SUPPORTED;
    private static final boolean IORING_REGISTER_BUFFER_RING_SUPPORTED;
    private static final boolean IORING_REGISTER_BUFFER_RING_INC_SUPPORTED;
    private static final boolean IORING_ACCEPT_MULTISHOT_ENABLED;
    private static final boolean IORING_RECV_MULTISHOT_ENABLED;
    private static final boolean IORING_RECVSEND_BUNDLE_ENABLED;
    private static final boolean IORING_POLL_ADD_MULTISHOT_ENABLED;
    static final int NUM_ELEMENTS_IOVEC;
    static final int DEFAULT_RING_SIZE;
    static final int DEFAULT_CQ_SIZE;
    static final int DISABLE_SETUP_CQ_SIZE = -1;
    private static final InternalLogger logger;

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static boolean isTcpFastOpenClientSideAvailable() {
        return IoUring.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_CLIENT;
    }

    public static boolean isTcpFastOpenServerSideAvailable() {
        return IoUring.isAvailable() && Native.IS_SUPPORTING_TCP_FASTOPEN_SERVER;
    }

    static boolean isCqeFSockNonEmptySupported() {
        return IORING_CQE_F_SOCK_NONEMPTY_SUPPORTED;
    }

    public static boolean isSpliceSupported() {
        return IORING_SPLICE_SUPPORTED;
    }

    static boolean isSendZcSupported() {
        return IORING_SEND_ZC_SUPPORTED;
    }

    static boolean isSendmsgZcSupported() {
        return IORING_SENDMSG_ZC_SUPPORTED;
    }

    static boolean isAcceptNoWaitSupported() {
        return IORING_ACCEPT_NO_WAIT_SUPPORTED;
    }

    static boolean isAcceptMultishotSupported() {
        return IORING_ACCEPT_MULTISHOT_SUPPORTED;
    }

    static boolean isRecvMultishotSupported() {
        return IORING_RECV_MULTISHOT_SUPPORTED;
    }

    static boolean isRecvsendBundleSupported() {
        return IORING_RECVSEND_BUNDLE_SUPPORTED;
    }

    static boolean isPollAddMultishotSupported() {
        return IORING_POLL_ADD_MULTISHOT_SUPPORTED;
    }

    static boolean isRegisterIowqMaxWorkersSupported() {
        return IORING_REGISTER_IOWQ_MAX_WORKERS_SUPPORTED;
    }

    static boolean isSetupCqeSizeSupported() {
        return IORING_SETUP_CQ_SIZE_SUPPORTED;
    }

    static boolean isSetupSubmitAllSupported() {
        return IORING_SETUP_SUBMIT_ALL_SUPPORTED;
    }

    static boolean isSetupCqeMixedSupported() {
        return IORING_SETUP_CQE_MIXED_SUPPORTED;
    }

    static boolean isSetupSingleIssuerSupported() {
        return IORING_SETUP_SINGLE_ISSUER_SUPPORTED;
    }

    static boolean isSetupDeferTaskrunSupported() {
        return IORING_SETUP_DEFER_TASKRUN_SUPPORTED;
    }

    static boolean isIoringSetupNoSqarraySupported() {
        return IORING_SETUP_NO_SQARRAY_SUPPORTED;
    }

    public static boolean isRegisterBufferRingSupported() {
        return IORING_REGISTER_BUFFER_RING_SUPPORTED;
    }

    public static boolean isRegisterBufferRingIncSupported() {
        return IORING_REGISTER_BUFFER_RING_INC_SUPPORTED;
    }

    public static boolean isAcceptMultishotEnabled() {
        return IORING_ACCEPT_MULTISHOT_ENABLED;
    }

    public static boolean isRecvMultishotEnabled() {
        return IORING_RECV_MULTISHOT_ENABLED;
    }

    public static boolean isRecvsendBundleEnabled() {
        return IORING_RECVSEND_BUNDLE_ENABLED;
    }

    public static boolean isPollAddMultishotEnabled() {
        return IORING_POLL_ADD_MULTISHOT_ENABLED;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    static long memoryAddress(ByteBuf buffer) {
        if (buffer.hasMemoryAddress()) {
            return buffer.memoryAddress();
        }
        ByteBuffer byteBuffer = buffer.internalNioBuffer(0, buffer.capacity());
        return Buffer.memoryAddress(byteBuffer) + (long)byteBuffer.position();
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    private static String supportedFeatures() {
        if (!IoUring.isAvailable()) {
            return "";
        }
        return "CQE_F_SOCK_NONEMPTY_SUPPORTED=" + IORING_CQE_F_SOCK_NONEMPTY_SUPPORTED + ", SPLICE_SUPPORTED=" + IORING_SPLICE_SUPPORTED + ", ACCEPT_NO_WAIT_SUPPORTED=" + IORING_ACCEPT_NO_WAIT_SUPPORTED + ", ACCEPT_MULTISHOT_SUPPORTED=" + IORING_ACCEPT_MULTISHOT_SUPPORTED + ", POLL_ADD_MULTISHOT_SUPPORTED=" + IORING_POLL_ADD_MULTISHOT_SUPPORTED + ", RECV_MULTISHOT_SUPPORTED=" + IORING_RECV_MULTISHOT_SUPPORTED + ", IORING_RECVSEND_BUNDLE_SUPPORTED=" + IORING_RECVSEND_BUNDLE_SUPPORTED + ", REGISTER_IOWQ_MAX_WORKERS_SUPPORTED=" + IORING_REGISTER_IOWQ_MAX_WORKERS_SUPPORTED + ", SETUP_SUBMIT_ALL_SUPPORTED=" + IORING_SETUP_SUBMIT_ALL_SUPPORTED + ", SETUP_CQE_MIXED_SUPPORTED=" + IORING_SETUP_CQE_MIXED_SUPPORTED + ", SETUP_CQ_SIZE_SUPPORTED=" + IORING_SETUP_CQ_SIZE_SUPPORTED + ", SETUP_SINGLE_ISSUER_SUPPORTED=" + IORING_SETUP_SINGLE_ISSUER_SUPPORTED + ", SETUP_DEFER_TASKRUN_SUPPORTED=" + IORING_SETUP_DEFER_TASKRUN_SUPPORTED + ", SETUP_NO_SQARRAY_SUPPORTED=" + IORING_SETUP_NO_SQARRAY_SUPPORTED + ", REGISTER_BUFFER_RING_SUPPORTED=" + IORING_REGISTER_BUFFER_RING_SUPPORTED + ", REGISTER_BUFFER_RING_INC_SUPPORTED=" + IORING_REGISTER_BUFFER_RING_INC_SUPPORTED + ", SEND_ZC_SUPPORTED=" + IORING_SEND_ZC_SUPPORTED + ", SENDMSG_ZC_SUPPORTED=" + IORING_SENDMSG_ZC_SUPPORTED;
    }

    public static String featureString() {
        if (!IoUring.isAvailable()) {
            Throwable t = IoUring.unavailabilityCause();
            return "IoUring unavailable: " + (t == null ? "unknown cause" : t.toString());
        }
        return "IoUring features: " + IoUring.supportedFeatures();
    }

    public String toString() {
        return IoUring.featureString();
    }

    private IoUring() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String kernelVersion;
        int numElementsIoVec;
        boolean registerBufferRingIncSupported;
        boolean registerBufferRingSupported;
        boolean noSqarraySupported;
        boolean deferTaskrunSupported;
        boolean singleIssuerSupported;
        boolean setUpCqSizeSupported;
        boolean cqeMixedSupported;
        boolean submitAllSupported;
        boolean registerIowqWorkersSupported;
        boolean pollAddMultishotSupported;
        boolean recvMultishotSupported;
        boolean recvsendBundleSupported;
        boolean acceptMultishotSupported;
        boolean acceptSupportNoWait;
        boolean sendmsgZcSupported;
        boolean sendZcSupported;
        boolean spliceSupported;
        boolean socketNonEmptySupported;
        Throwable cause;
        block19: {
            logger = InternalLoggerFactory.getInstance(IoUring.class);
            cause = null;
            socketNonEmptySupported = false;
            spliceSupported = false;
            sendZcSupported = false;
            sendmsgZcSupported = false;
            acceptSupportNoWait = false;
            acceptMultishotSupported = false;
            recvsendBundleSupported = false;
            recvMultishotSupported = false;
            pollAddMultishotSupported = false;
            registerIowqWorkersSupported = false;
            submitAllSupported = false;
            cqeMixedSupported = false;
            setUpCqSizeSupported = false;
            singleIssuerSupported = false;
            deferTaskrunSupported = false;
            noSqarraySupported = false;
            registerBufferRingSupported = false;
            registerBufferRingIncSupported = false;
            numElementsIoVec = 10;
            kernelVersion = "[unknown]";
            try {
                if (SystemPropertyUtil.getBoolean("io.netty.transport.noNative", false)) {
                    cause = new UnsupportedOperationException("Native transport was explicit disabled with -Dio.netty.transport.noNative=true");
                    break block19;
                }
                kernelVersion = Native.kernelVersion();
                Native.checkKernelVersion(kernelVersion);
                if (PlatformDependent.javaVersion() >= 9) {
                    RingBuffer ringBuffer = null;
                    try {
                        ringBuffer = Native.createRingBuffer(1, 0);
                        if ((ringBuffer.features() & 4) == 0) {
                            throw new UnsupportedOperationException("IORING_FEAT_SUBMIT_STABLE not supported!");
                        }
                        numElementsIoVec = SystemPropertyUtil.getInt("io.netty.iouring.numElementsIoVec", 10 * Limits.IOV_MAX);
                        Native.IoUringProbe ioUringProbe = Native.ioUringProbe(ringBuffer.fd());
                        Native.checkAllIOSupported(ioUringProbe);
                        socketNonEmptySupported = Native.isCqeFSockNonEmptySupported(ioUringProbe);
                        spliceSupported = Native.isSpliceSupported(ioUringProbe);
                        recvsendBundleSupported = (ringBuffer.features() & 0x4000) != 0;
                        sendZcSupported = Native.isSendZcSupported(ioUringProbe);
                        sendmsgZcSupported = Native.isSendmsgZcSupported(ioUringProbe);
                        acceptSupportNoWait = recvsendBundleSupported;
                        acceptMultishotSupported = Native.isAcceptMultishotSupported(ioUringProbe);
                        recvMultishotSupported = Native.isRecvMultishotSupported();
                        pollAddMultishotSupported = Native.isPollAddMultiShotSupported(ioUringProbe);
                        registerIowqWorkersSupported = Native.isRegisterIoWqWorkerSupported(ringBuffer.fd());
                        submitAllSupported = Native.ioUringSetupSupportsFlags(128);
                        cqeMixedSupported = Native.ioUringSetupSupportsFlags(262144);
                        setUpCqSizeSupported = Native.ioUringSetupSupportsFlags(8);
                        singleIssuerSupported = Native.ioUringSetupSupportsFlags(4096);
                        deferTaskrunSupported = Native.ioUringSetupSupportsFlags(12288);
                        noSqarraySupported = Native.ioUringSetupSupportsFlags(65536);
                        registerBufferRingSupported = Native.isRegisterBufferRingSupported(ringBuffer.fd(), 0);
                        registerBufferRingIncSupported = Native.isRegisterBufferRingSupported(ringBuffer.fd(), 2);
                        break block19;
                    }
                    finally {
                        if (ringBuffer != null) {
                            try {
                                ringBuffer.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                cause = new UnsupportedOperationException("Java 9+ is required");
            }
            catch (Throwable t) {
                cause = t;
            }
        }
        UNAVAILABILITY_CAUSE = cause;
        IORING_CQE_F_SOCK_NONEMPTY_SUPPORTED = socketNonEmptySupported;
        IORING_SPLICE_SUPPORTED = spliceSupported;
        IORING_SEND_ZC_SUPPORTED = sendZcSupported;
        IORING_SENDMSG_ZC_SUPPORTED = sendmsgZcSupported;
        IORING_ACCEPT_NO_WAIT_SUPPORTED = acceptSupportNoWait;
        IORING_ACCEPT_MULTISHOT_SUPPORTED = acceptMultishotSupported;
        IORING_RECV_MULTISHOT_SUPPORTED = recvMultishotSupported;
        IORING_RECVSEND_BUNDLE_SUPPORTED = recvsendBundleSupported;
        IORING_POLL_ADD_MULTISHOT_SUPPORTED = pollAddMultishotSupported;
        IORING_REGISTER_IOWQ_MAX_WORKERS_SUPPORTED = registerIowqWorkersSupported;
        IORING_SETUP_SUBMIT_ALL_SUPPORTED = submitAllSupported;
        IORING_SETUP_CQE_MIXED_SUPPORTED = cqeMixedSupported;
        IORING_SETUP_CQ_SIZE_SUPPORTED = setUpCqSizeSupported;
        IORING_SETUP_SINGLE_ISSUER_SUPPORTED = singleIssuerSupported;
        IORING_SETUP_DEFER_TASKRUN_SUPPORTED = deferTaskrunSupported;
        IORING_SETUP_NO_SQARRAY_SUPPORTED = noSqarraySupported;
        IORING_REGISTER_BUFFER_RING_SUPPORTED = registerBufferRingSupported;
        IORING_REGISTER_BUFFER_RING_INC_SUPPORTED = registerBufferRingIncSupported;
        IORING_ACCEPT_MULTISHOT_ENABLED = IORING_ACCEPT_MULTISHOT_SUPPORTED && SystemPropertyUtil.getBoolean("io.netty.iouring.acceptMultiShotEnabled", true);
        IORING_RECV_MULTISHOT_ENABLED = IORING_RECV_MULTISHOT_SUPPORTED && SystemPropertyUtil.getBoolean("io.netty.iouring.recvMultiShotEnabled", true);
        IORING_RECVSEND_BUNDLE_ENABLED = IORING_RECVSEND_BUNDLE_SUPPORTED && SystemPropertyUtil.getBoolean("io.netty.iouring.recvsendBundleEnabled", false);
        IORING_POLL_ADD_MULTISHOT_ENABLED = IORING_POLL_ADD_MULTISHOT_SUPPORTED && SystemPropertyUtil.getBoolean("io.netty.iouring.pollAddMultishotEnabled", true);
        NUM_ELEMENTS_IOVEC = numElementsIoVec;
        DEFAULT_RING_SIZE = Math.max(16, SystemPropertyUtil.getInt("io.netty.iouring.ringSize", 128));
        DEFAULT_CQ_SIZE = IORING_SETUP_CQ_SIZE_SUPPORTED ? Math.max(DEFAULT_RING_SIZE, SystemPropertyUtil.getInt("io.netty.iouring.cqSize", 4096)) : -1;
        if (cause != null) {
            if (logger.isTraceEnabled()) {
                logger.debug("IoUring support is not available using kernel {}", (Object)kernelVersion, (Object)cause);
            } else if (logger.isDebugEnabled()) {
                logger.debug("IoUring support is not available using kernel {}: {}", (Object)kernelVersion, (Object)cause.getMessage());
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("IoUring support is available using kernel {}: {}", (Object)kernelVersion, (Object)IoUring.supportedFeatures());
        }
    }
}

