/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.proxy.command.brigadier.VelocityArgumentCommandNode;
import com.velocitypowered.proxy.command.brigadier.VelocityBrigadierCommandWrapper;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class VelocityCommands {
    public static final String ARGS_NODE_NAME = "arguments";

    public static CommandNode<CommandSource> wrap(CommandNode<CommandSource> delegate, @Nullable Object registrant) {
        Preconditions.checkNotNull(delegate, "delegate");
        if (registrant == null) {
            return delegate;
        }
        Command<CommandSource> maybeCommand = delegate.getCommand();
        if (maybeCommand != null && !(maybeCommand instanceof VelocityBrigadierCommandWrapper)) {
            maybeCommand = VelocityBrigadierCommandWrapper.wrap(delegate.getCommand(), registrant);
        }
        CommandNode<CommandSource> commandNode = delegate;
        Objects.requireNonNull(commandNode);
        CommandNode<CommandSource> commandNode2 = commandNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LiteralCommandNode.class, VelocityArgumentCommandNode.class, ArgumentCommandNode.class}, commandNode2, n)) {
            case 0 -> {
                LiteralCommandNode lcn = (LiteralCommandNode)commandNode2;
                LiteralArgumentBuilder<CommandSource> literalBuilder = VelocityCommands.shallowCopyAsBuilder(lcn, delegate.getName(), true);
                literalBuilder.executes(maybeCommand);
                for (CommandNode<CommandSource> child : delegate.getChildren()) {
                    literalBuilder.then(VelocityCommands.wrap(child, registrant));
                }
                if (delegate.getRedirect() != null) {
                    literalBuilder.redirect(VelocityCommands.wrap(delegate.getRedirect(), registrant));
                }
                yield literalBuilder.build();
            }
            case 1 -> {
                VelocityArgumentCommandNode vacn = (VelocityArgumentCommandNode)commandNode2;
                yield vacn.withCommand(maybeCommand).withRedirect(delegate.getRedirect() != null ? VelocityCommands.wrap(delegate.getRedirect(), registrant) : null);
            }
            case 2 -> {
                ArgumentCommandNode node = (ArgumentCommandNode)commandNode2;
                RequiredArgumentBuilder argBuilder = (RequiredArgumentBuilder)node.createBuilder().executes(maybeCommand);
                for (CommandNode<CommandSource> child : delegate.getChildren()) {
                    argBuilder.then(VelocityCommands.wrap(child, registrant));
                }
                if (delegate.getRedirect() != null) {
                    argBuilder.redirect(VelocityCommands.wrap(delegate.getRedirect(), registrant));
                }
                yield argBuilder.build();
            }
            default -> throw new IllegalArgumentException("Unsupported node type: " + String.valueOf(delegate.getClass()));
        };
    }

    static String normalizeInput(String input, boolean trim) {
        String command = trim ? input.trim() : input;
        int firstSep = command.indexOf(32);
        if (firstSep != -1) {
            return command.substring(0, firstSep).toLowerCase(Locale.ENGLISH) + command.substring(firstSep);
        }
        return command.toLowerCase(Locale.ENGLISH);
    }

    public static String readAlias(List<? extends ParsedCommandNode<?>> nodes) {
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException("Cannot read alias from empty node list");
        }
        return nodes.getFirst().getNode().getName();
    }

    public static <V> V readArguments(Map<String, ? extends ParsedArgument<?, ?>> arguments, Class<V> type, V fallback) {
        ParsedArgument<?, ?> argument = arguments.get(ARGS_NODE_NAME);
        if (argument == null) {
            return fallback;
        }
        Object result = argument.getResult();
        try {
            return type.cast(result);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Parsed argument is of type " + String.valueOf(result.getClass()) + ", expected " + String.valueOf(type), e);
        }
    }

    public static boolean isValidAlias(String alias) {
        return alias.equals(alias.toLowerCase(Locale.ENGLISH));
    }

    public static LiteralCommandNode<CommandSource> shallowCopy(LiteralCommandNode<CommandSource> original, String newName) {
        return VelocityCommands.shallowCopy(original, newName, original.getCommand());
    }

    private static LiteralCommandNode<CommandSource> shallowCopy(LiteralCommandNode<CommandSource> original, String newName, Command<CommandSource> newCommand) {
        return ((LiteralArgumentBuilder)VelocityCommands.shallowCopyAsBuilder(original, newName, false).executes(newCommand)).build();
    }

    private static LiteralArgumentBuilder<CommandSource> shallowCopyAsBuilder(LiteralCommandNode<CommandSource> original, String newName, boolean skipChildren) {
        Preconditions.checkNotNull(original, "original");
        Preconditions.checkNotNull(newName, "secondaryAlias");
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(newName).requires(original.getRequirement())).requiresWithContext(original.getContextRequirement())).forward(original.getRedirect(), original.getRedirectModifier(), original.isFork())).executes(original.getCommand());
        if (!skipChildren) {
            for (CommandNode child : original.getChildren()) {
                builder.then(child);
            }
        }
        return builder;
    }

    static <S> @Nullable VelocityArgumentCommandNode<S, ?> getArgumentsNode(LiteralCommandNode<S> alias) {
        CommandNode node = alias.getChild(ARGS_NODE_NAME);
        if (node instanceof VelocityArgumentCommandNode) {
            return (VelocityArgumentCommandNode)node;
        }
        return null;
    }

    public static boolean isArgumentsNode(CommandNode<?> node) {
        return node instanceof VelocityArgumentCommandNode && node.getName().equals(ARGS_NODE_NAME);
    }

    private VelocityCommands() {
        throw new AssertionError();
    }
}

