/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.IoHandle;
import io.netty.channel.IoHandler;
import io.netty.channel.IoHandlerContext;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.IoOps;
import io.netty.channel.IoRegistration;
import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.channel.uring.CompletionCallback;
import io.netty.channel.uring.CompletionQueue;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringBufferRing;
import io.netty.channel.uring.IoUringBufferRingConfig;
import io.netty.channel.uring.IoUringIoEvent;
import io.netty.channel.uring.IoUringIoHandle;
import io.netty.channel.uring.IoUringIoHandlerConfig;
import io.netty.channel.uring.IoUringIoOps;
import io.netty.channel.uring.MsgHdrMemoryArray;
import io.netty.channel.uring.Native;
import io.netty.channel.uring.RingBuffer;
import io.netty.channel.uring.SubmissionQueue;
import io.netty.channel.uring.UserData;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.ThreadAwareExecutor;
import io.netty.util.internal.CleanableDirectBuffer;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class IoUringIoHandler
implements IoHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(IoUringIoHandler.class);
    private final RingBuffer ringBuffer;
    private final IntObjectMap<IoUringBufferRing> registeredIoUringBufferRing;
    private final IntObjectMap<DefaultIoUringIoRegistration> registrations;
    private final byte[] inet4AddressArray = new byte[4];
    private final byte[] inet6AddressArray = new byte[16];
    private final AtomicBoolean eventfdAsyncNotify = new AtomicBoolean();
    private final FileDescriptor eventfd;
    private final CleanableDirectBuffer eventfdReadBufCleanable;
    private final ByteBuffer eventfdReadBuf;
    private final long eventfdReadBufAddress;
    private final CleanableDirectBuffer timeoutMemoryCleanable;
    private final ByteBuffer timeoutMemory;
    private final long timeoutMemoryAddress;
    private final IovArray iovArray;
    private final MsgHdrMemoryArray msgHdrMemoryArray;
    private long eventfdReadSubmitted;
    private boolean eventFdClosing;
    private volatile boolean shuttingDown;
    private boolean closeCompleted;
    private int nextRegistrationId = Integer.MIN_VALUE;
    private static final int EVENTFD_ID = Integer.MAX_VALUE;
    private static final int RINGFD_ID = 0x7FFFFFFE;
    private static final int INVALID_ID = 0;
    private static final int KERNEL_TIMESPEC_SIZE = 16;
    private static final int KERNEL_TIMESPEC_TV_SEC_FIELD = 0;
    private static final int KERNEL_TIMESPEC_TV_NSEC_FIELD = 8;
    private final ThreadAwareExecutor executor;

    IoUringIoHandler(ThreadAwareExecutor executor, IoUringIoHandlerConfig config) {
        IoUring.ensureAvailability();
        this.executor = Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(config, "config");
        int setupFlags = Native.setupFlags(config.singleIssuer());
        int cqSize = 2 * config.getRingSize();
        if (config.needSetupCqeSize()) {
            assert (IoUring.isSetupCqeSizeSupported());
            setupFlags |= 8;
            cqSize = config.getCqSize();
        }
        this.ringBuffer = Native.createRingBuffer(config.getRingSize(), cqSize, setupFlags);
        if (IoUring.isRegisterIowqMaxWorkersSupported() && config.needRegisterIowqMaxWorker()) {
            int maxBoundedWorker = Math.max(config.getMaxBoundedWorker(), 0);
            int maxUnboundedWorker = Math.max(config.getMaxUnboundedWorker(), 0);
            int result = Native.ioUringRegisterIoWqMaxWorkers(this.ringBuffer.fd(), maxBoundedWorker, maxUnboundedWorker);
            if (result < 0) {
                this.ringBuffer.close();
                throw new UncheckedIOException(Errors.newIOException("io_uring_register", result));
            }
        }
        this.registeredIoUringBufferRing = new IntObjectHashMap<IoUringBufferRing>();
        Set<IoUringBufferRingConfig> bufferRingConfigs = config.getInternBufferRingConfigs();
        if (bufferRingConfigs != null && !bufferRingConfigs.isEmpty()) {
            for (IoUringBufferRingConfig bufferRingConfig : bufferRingConfigs) {
                try {
                    IoUringBufferRing ring = IoUringIoHandler.newBufferRing(this.ringBuffer.fd(), bufferRingConfig);
                    this.registeredIoUringBufferRing.put(bufferRingConfig.bufferGroupId(), ring);
                }
                catch (Errors.NativeIoException e) {
                    for (IoUringBufferRing bufferRing : this.registeredIoUringBufferRing.values()) {
                        bufferRing.close();
                    }
                    this.ringBuffer.close();
                    throw new UncheckedIOException(e);
                }
            }
        }
        this.registrations = new IntObjectHashMap<DefaultIoUringIoRegistration>();
        this.eventfd = Native.newBlockingEventFd();
        this.eventfdReadBufCleanable = Buffer.allocateDirectBufferWithNativeOrder(8);
        this.eventfdReadBuf = this.eventfdReadBufCleanable.buffer();
        this.eventfdReadBufAddress = Buffer.memoryAddress(this.eventfdReadBuf);
        this.timeoutMemoryCleanable = Buffer.allocateDirectBufferWithNativeOrder(16);
        this.timeoutMemory = this.timeoutMemoryCleanable.buffer();
        this.timeoutMemoryAddress = Buffer.memoryAddress(this.timeoutMemory);
        this.iovArray = new IovArray(IoUring.NUM_ELEMENTS_IOVEC);
        this.msgHdrMemoryArray = new MsgHdrMemoryArray(1024);
    }

    @Override
    public void initialize() {
        this.ringBuffer.enable();
        for (IoUringBufferRing bufferRing : this.registeredIoUringBufferRing.values()) {
            bufferRing.initialize();
        }
    }

    @Override
    public int run(IoHandlerContext context) {
        int processed;
        if (this.closeCompleted) {
            if (context.shouldReportActiveIoTime()) {
                context.reportActiveIoTime(0L);
            }
            return 0;
        }
        SubmissionQueue submissionQueue = this.ringBuffer.ioUringSubmissionQueue();
        CompletionQueue completionQueue = this.ringBuffer.ioUringCompletionQueue();
        if (!completionQueue.hasCompletions() && context.canBlock()) {
            if (this.eventfdReadSubmitted == 0L) {
                this.submitEventFdRead();
            }
            long timeoutNanos = context.deadlineNanos() == -1L ? -1L : context.delayNanos(System.nanoTime());
            this.submitAndWaitWithTimeout(submissionQueue, false, timeoutNanos);
        } else {
            this.submitAndClearNow(submissionQueue);
        }
        if (context.shouldReportActiveIoTime()) {
            long activeIoStartTimeNanos = System.nanoTime();
            processed = this.processCompletionsAndHandleOverflow(submissionQueue, completionQueue, this::handle);
            long activeIoEndTimeNanos = System.nanoTime();
            context.reportActiveIoTime(activeIoEndTimeNanos - activeIoStartTimeNanos);
        } else {
            processed = this.processCompletionsAndHandleOverflow(submissionQueue, completionQueue, this::handle);
        }
        return processed;
    }

    private int processCompletionsAndHandleOverflow(SubmissionQueue submissionQueue, CompletionQueue completionQueue, CompletionCallback callback) {
        int processed = 0;
        for (int i = 0; i < 128; ++i) {
            int p = completionQueue.process(callback);
            if ((submissionQueue.flags() & 2) != 0) {
                logger.warn("CompletionQueue overflow detected, consider increasing size: {} ", (Object)completionQueue.ringEntries);
                this.submitAndClearNow(submissionQueue);
            } else if (p == 0 && (submissionQueue.count() == 0 || this.submitAndClearNow(submissionQueue) == 0 && !completionQueue.hasCompletions())) break;
            processed += p;
        }
        return processed;
    }

    private int submitAndClearNow(SubmissionQueue submissionQueue) {
        int submitted = submissionQueue.submitAndGetNow();
        this.iovArray.clear();
        this.msgHdrMemoryArray.clear();
        return submitted;
    }

    private static IoUringBufferRing newBufferRing(int ringFd, IoUringBufferRingConfig bufferRingConfig) throws Errors.NativeIoException {
        int flags;
        short bufferGroupId;
        short bufferRingSize = bufferRingConfig.bufferRingSize();
        long ioUringBufRingAddr = Native.ioUringRegisterBufRing(ringFd, bufferRingSize, bufferGroupId = bufferRingConfig.bufferGroupId(), flags = bufferRingConfig.isIncremental() ? 2 : 0);
        if (ioUringBufRingAddr < 0L) {
            throw Errors.newIOException("ioUringRegisterBufRing", (int)ioUringBufRingAddr);
        }
        return new IoUringBufferRing(ringFd, Buffer.wrapMemoryAddressWithNativeOrder(ioUringBufRingAddr, Native.ioUringBufRingSize(bufferRingSize)), bufferRingSize, bufferRingConfig.batchSize(), bufferGroupId, bufferRingConfig.isIncremental(), bufferRingConfig.allocator(), bufferRingConfig.isBatchAllocation());
    }

    IoUringBufferRing findBufferRing(short bgId) {
        IoUringBufferRing cached = this.registeredIoUringBufferRing.get(bgId);
        if (cached != null) {
            return cached;
        }
        throw new IllegalArgumentException(String.format("Cant find bgId:%d, please register it in ioUringIoHandler", bgId));
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the IO event loop.", throwable);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void handle(int res, int flags, long udata, ByteBuffer extraCqeData) {
        try {
            int id = UserData.decodeId(udata);
            byte op = UserData.decodeOp(udata);
            short data = UserData.decodeData(udata);
            if (logger.isTraceEnabled()) {
                logger.trace("completed(ring {}): {}(id={}, res={})", this.ringBuffer.fd(), Native.opToStr(op), data, res);
            }
            if (id == Integer.MAX_VALUE) {
                this.handleEventFdRead();
                return;
            }
            if (id == 0x7FFFFFFE) {
                return;
            }
            DefaultIoUringIoRegistration registration = this.registrations.get(id);
            if (registration == null) {
                logger.debug("ignoring {} completion for unknown registration (id={}, res={})", Native.opToStr(op), id, res);
                return;
            }
            registration.handle(res, flags, op, data, extraCqeData);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable throwable) {
            IoUringIoHandler.handleLoopException(throwable);
        }
    }

    private void handleEventFdRead() {
        this.eventfdReadSubmitted = 0L;
        if (!this.eventFdClosing) {
            this.eventfdAsyncNotify.set(false);
            this.submitEventFdRead();
        }
    }

    private void submitEventFdRead() {
        SubmissionQueue submissionQueue = this.ringBuffer.ioUringSubmissionQueue();
        long udata = UserData.encode(Integer.MAX_VALUE, (byte)22, (short)0);
        this.eventfdReadSubmitted = submissionQueue.addEventFdRead(this.eventfd.intValue(), this.eventfdReadBufAddress, 0, 8, udata);
    }

    private int submitAndWaitWithTimeout(SubmissionQueue submissionQueue, boolean linkTimeout, long timeoutNanoSeconds) {
        if (timeoutNanoSeconds != -1L) {
            long nanoSeconds;
            long seconds;
            long udata = UserData.encode(0x7FFFFFFE, linkTimeout ? (byte)15 : 11, (short)0);
            if (timeoutNanoSeconds == 0L) {
                seconds = 0L;
                nanoSeconds = 0L;
            } else {
                seconds = (int)Math.min(timeoutNanoSeconds / 1000000000L, Integer.MAX_VALUE);
                nanoSeconds = (int)Math.max(timeoutNanoSeconds - seconds * 1000000000L, 0L);
            }
            this.timeoutMemory.putLong(0, seconds);
            this.timeoutMemory.putLong(8, nanoSeconds);
            if (linkTimeout) {
                submissionQueue.addLinkTimeout(this.timeoutMemoryAddress, udata);
            } else {
                submissionQueue.addTimeout(this.timeoutMemoryAddress, udata);
            }
        }
        int submitted = submissionQueue.submitAndGet();
        this.iovArray.clear();
        this.msgHdrMemoryArray.clear();
        return submitted;
    }

    @Override
    public void prepareToDestroy() {
        this.shuttingDown = true;
        CompletionQueue completionQueue = this.ringBuffer.ioUringCompletionQueue();
        SubmissionQueue submissionQueue = this.ringBuffer.ioUringSubmissionQueue();
        ArrayList copy = new ArrayList(this.registrations.values());
        for (DefaultIoUringIoRegistration registration : copy) {
            registration.close();
        }
        Native.eventFdWrite(this.eventfd.intValue(), 1L);
        long udata = UserData.encode(0x7FFFFFFE, (byte)0, (short)0);
        submissionQueue.addNop((byte)Native.IOSQE_IO_DRAIN, udata);
        submissionQueue.submitAndGet();
        while (completionQueue.hasCompletions()) {
            this.processCompletionsAndHandleOverflow(submissionQueue, completionQueue, this::handle);
            if (submissionQueue.count() <= 0) continue;
            submissionQueue.submitAndGetNow();
        }
    }

    @Override
    public void destroy() {
        SubmissionQueue submissionQueue = this.ringBuffer.ioUringSubmissionQueue();
        CompletionQueue completionQueue = this.ringBuffer.ioUringCompletionQueue();
        this.drainEventFd();
        if (submissionQueue.remaining() < 2) {
            submissionQueue.submit();
        }
        long udata = UserData.encode(0x7FFFFFFE, (byte)0, (short)0);
        submissionQueue.addNop((byte)(Native.IOSQE_IO_DRAIN | Native.IOSQE_LINK), udata);
        this.submitAndWaitWithTimeout(submissionQueue, true, TimeUnit.MILLISECONDS.toNanos(200L));
        completionQueue.process(this::handle);
        for (IoUringBufferRing ioUringBufferRing : this.registeredIoUringBufferRing.values()) {
            ioUringBufferRing.close();
        }
        this.completeRingClose();
    }

    private void drainEventFd() {
        CompletionQueue completionQueue = this.ringBuffer.ioUringCompletionQueue();
        SubmissionQueue submissionQueue = this.ringBuffer.ioUringSubmissionQueue();
        assert (!this.eventFdClosing);
        this.eventFdClosing = true;
        boolean eventPending = this.eventfdAsyncNotify.getAndSet(true);
        if (eventPending) {
            while (this.eventfdReadSubmitted == 0L) {
                this.submitEventFdRead();
                submissionQueue.submit();
            }
            class DrainFdEventCallback
            implements CompletionCallback {
                boolean eventFdDrained;

                DrainFdEventCallback() {
                }

                @Override
                public void handle(int res, int flags, long udata, ByteBuffer extraCqeData) {
                    if (UserData.decodeId(udata) == Integer.MAX_VALUE) {
                        this.eventFdDrained = true;
                    }
                    IoUringIoHandler.this.handle(res, flags, udata, extraCqeData);
                }
            }
            DrainFdEventCallback handler = new DrainFdEventCallback();
            completionQueue.process(handler);
            while (!handler.eventFdDrained) {
                submissionQueue.submitAndGet();
                this.processCompletionsAndHandleOverflow(submissionQueue, completionQueue, handler);
            }
        }
        if (this.eventfdReadSubmitted != 0L) {
            long udata = UserData.encode(Integer.MAX_VALUE, (byte)14, (short)0);
            submissionQueue.addCancel(this.eventfdReadSubmitted, udata);
            this.eventfdReadSubmitted = 0L;
            submissionQueue.submit();
        }
    }

    private void completeRingClose() {
        if (this.closeCompleted) {
            return;
        }
        this.closeCompleted = true;
        this.ringBuffer.close();
        try {
            this.eventfd.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close eventfd", e);
        }
        this.eventfdReadBufCleanable.clean();
        this.timeoutMemoryCleanable.clean();
        this.iovArray.release();
        this.msgHdrMemoryArray.release();
    }

    @Override
    public IoRegistration register(IoHandle handle) throws Exception {
        int id;
        DefaultIoUringIoRegistration old;
        IoUringIoHandle ioHandle = IoUringIoHandler.cast(handle);
        if (this.shuttingDown) {
            throw new IllegalStateException("IoUringIoHandler is shutting down");
        }
        DefaultIoUringIoRegistration registration = new DefaultIoUringIoRegistration(this.executor, ioHandle);
        while ((old = this.registrations.put(id = this.nextRegistrationId(), registration)) != null) {
            assert (old.handle != registration.handle);
            this.registrations.put(id, old);
        }
        registration.setId(id);
        ioHandle.registered();
        return registration;
    }

    private int nextRegistrationId() {
        int id;
        do {
            ++this.nextRegistrationId;
        } while (id == 0x7FFFFFFE || id == Integer.MAX_VALUE || id == 0);
        return id;
    }

    private static IoUringIoHandle cast(IoHandle handle) {
        if (handle instanceof IoUringIoHandle) {
            return (IoUringIoHandle)handle;
        }
        throw new IllegalArgumentException("IoHandle of type " + StringUtil.simpleClassName(handle) + " not supported");
    }

    @Override
    public void wakeup() {
        if (!this.executor.isExecutorThread(Thread.currentThread()) && !this.eventfdAsyncNotify.getAndSet(true)) {
            Native.eventFdWrite(this.eventfd.intValue(), 1L);
        }
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return IoUringIoHandle.class.isAssignableFrom(handleType);
    }

    IovArray iovArray() {
        if (this.iovArray.isFull()) {
            this.submitAndClearNow(this.ringBuffer.ioUringSubmissionQueue());
        }
        assert (this.iovArray.count() == 0);
        return this.iovArray;
    }

    MsgHdrMemoryArray msgHdrMemoryArray() {
        if (this.msgHdrMemoryArray.isFull()) {
            this.submitAndClearNow(this.ringBuffer.ioUringSubmissionQueue());
        }
        return this.msgHdrMemoryArray;
    }

    byte[] inet4AddressArray() {
        return this.inet4AddressArray;
    }

    byte[] inet6AddressArray() {
        return this.inet6AddressArray;
    }

    public static IoHandlerFactory newFactory() {
        return IoUringIoHandler.newFactory(new IoUringIoHandlerConfig());
    }

    public static IoHandlerFactory newFactory(int ringSize) {
        IoUringIoHandlerConfig configuration = new IoUringIoHandlerConfig();
        configuration.setRingSize(ringSize);
        return eventLoop -> new IoUringIoHandler(eventLoop, configuration);
    }

    public static IoHandlerFactory newFactory(IoUringIoHandlerConfig config) {
        IoUring.ensureAvailability();
        final IoUringIoHandlerConfig copy = ObjectUtil.checkNotNull(config, "config").verifyAndClone();
        return new IoHandlerFactory(){

            @Override
            public IoHandler newHandler(ThreadAwareExecutor eventLoop) {
                return new IoUringIoHandler(eventLoop, copy);
            }

            @Override
            public boolean isChangingThreadSupported() {
                return !copy.singleIssuer();
            }
        };
    }

    private final class DefaultIoUringIoRegistration
    implements IoRegistration {
        private final AtomicBoolean canceled = new AtomicBoolean();
        private final ThreadAwareExecutor executor;
        private final IoUringIoEvent event = new IoUringIoEvent(0, 0, 0, 0);
        final IoUringIoHandle handle;
        private boolean removeLater;
        private int outstandingCompletions;
        private int id;

        DefaultIoUringIoRegistration(ThreadAwareExecutor executor, IoUringIoHandle handle) {
            this.executor = executor;
            this.handle = handle;
        }

        void setId(int id) {
            this.id = id;
        }

        @Override
        public long submit(IoOps ops) {
            IoUringIoOps ioOps = (IoUringIoOps)ops;
            if (!this.isValid()) {
                return 0L;
            }
            if ((ioOps.flags() & 0x40) != 0) {
                throw new IllegalArgumentException("IOSQE_CQE_SKIP_SUCCESS not supported");
            }
            long udata = UserData.encode(this.id, ioOps.opcode(), ioOps.data());
            if (this.executor.isExecutorThread(Thread.currentThread())) {
                this.submit0(ioOps, udata);
            } else {
                this.executor.execute(() -> this.submit0(ioOps, udata));
            }
            return udata;
        }

        private void submit0(IoUringIoOps ioOps, long udata) {
            IoUringIoHandler.this.ringBuffer.ioUringSubmissionQueue().enqueueSqe(ioOps.opcode(), ioOps.flags(), ioOps.ioPrio(), ioOps.fd(), ioOps.union1(), ioOps.union2(), ioOps.len(), ioOps.union3(), udata, ioOps.union4(), ioOps.personality(), ioOps.union5(), ioOps.union6());
            ++this.outstandingCompletions;
        }

        @Override
        public <T> T attachment() {
            return (T)IoUringIoHandler.this;
        }

        @Override
        public boolean isValid() {
            return !this.canceled.get();
        }

        @Override
        public boolean cancel() {
            if (!this.canceled.compareAndSet(false, true)) {
                return false;
            }
            if (this.executor.isExecutorThread(Thread.currentThread())) {
                this.tryRemove();
            } else {
                this.executor.execute(this::tryRemove);
            }
            return true;
        }

        private void tryRemove() {
            if (this.outstandingCompletions > 0) {
                this.removeLater = true;
                return;
            }
            this.remove();
        }

        private void remove() {
            DefaultIoUringIoRegistration old = (DefaultIoUringIoRegistration)IoUringIoHandler.this.registrations.remove(this.id);
            assert (old == this);
            this.handle.unregistered();
        }

        void close() {
            assert (this.executor.isExecutorThread(Thread.currentThread()));
            try {
                this.handle.close();
            }
            catch (Exception e) {
                logger.debug("Exception during closing " + String.valueOf(this.handle), e);
            }
        }

        void handle(int res, int flags, byte op, short data, ByteBuffer extraCqeData) {
            this.event.update(res, flags, op, data, extraCqeData);
            this.handle.handle(this, this.event);
            if ((flags & 2) == 0 && --this.outstandingCompletions == 0 && this.removeLater) {
                this.removeLater = false;
                this.remove();
            }
        }
    }
}

