/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.network;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.velocitypowered.api.event.proxy.ListenerBoundEvent;
import com.velocitypowered.api.event.proxy.ListenerCloseEvent;
import com.velocitypowered.api.network.ListenerType;
import com.velocitypowered.natives.util.Natives;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.network.BackendChannelInitializer;
import com.velocitypowered.proxy.network.BackendChannelInitializerHolder;
import com.velocitypowered.proxy.network.Endpoint;
import com.velocitypowered.proxy.network.ServerChannelInitializer;
import com.velocitypowered.proxy.network.ServerChannelInitializerHolder;
import com.velocitypowered.proxy.network.TransportType;
import com.velocitypowered.proxy.network.netty.SeparatePoolInetNameResolver;
import com.velocitypowered.proxy.protocol.netty.GameSpyQueryHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.unix.UnixChannelOption;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.MultithreadEventExecutorGroup;
import java.net.InetSocketAddress;
import java.net.http.HttpClient;
import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ConnectionManager {
    private static final WriteBufferWaterMark SERVER_WRITE_MARK = new WriteBufferWaterMark(0x100000, 0x200000);
    private static final Logger LOGGER = LogManager.getLogger(ConnectionManager.class);
    private final Multimap<InetSocketAddress, Endpoint> endpoints = HashMultimap.create();
    private final TransportType transportType;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final VelocityServer server;
    public final ServerChannelInitializerHolder serverChannelInitializer;
    public final BackendChannelInitializerHolder backendChannelInitializer;
    private final SeparatePoolInetNameResolver resolver;

    public ConnectionManager(VelocityServer server) {
        this.server = server;
        this.transportType = TransportType.bestType();
        this.bossGroup = this.transportType.createEventLoopGroup(TransportType.Type.BOSS);
        this.workerGroup = this.transportType.createEventLoopGroup(TransportType.Type.WORKER);
        this.serverChannelInitializer = new ServerChannelInitializerHolder(new ServerChannelInitializer(this.server));
        this.backendChannelInitializer = new BackendChannelInitializerHolder(new BackendChannelInitializer(this.server));
        this.resolver = new SeparatePoolInetNameResolver(GlobalEventExecutor.INSTANCE);
    }

    public void logChannelInformation() {
        LOGGER.info("Connections will use {} channels, {} compression, {} ciphers", (Object)this.transportType, (Object)Natives.compress.getLoadedVariant(), (Object)Natives.cipher.getLoadedVariant());
    }

    public void bind(InetSocketAddress address) {
        ServerBootstrap bootstrap = (ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channelFactory(this.transportType.serverSocketChannelFactory)).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, SERVER_WRITE_MARK).childHandler((ChannelHandler)this.serverChannelInitializer.get()).childOption(ChannelOption.TCP_NODELAY, true).childOption(ChannelOption.IP_TOS, 24).localAddress(address);
        if (this.server.getConfiguration().useTcpFastOpen()) {
            bootstrap.option(ChannelOption.TCP_FASTOPEN, 3);
        }
        if (this.server.getConfiguration().isEnableReusePort()) {
            ((ServerBootstrap)bootstrap.option(UnixChannelOption.SO_REUSEPORT, true)).group(this.workerGroup);
        } else {
            bootstrap.group(this.bossGroup, this.workerGroup);
        }
        int binds = this.server.getConfiguration().isEnableReusePort() ? ((MultithreadEventExecutorGroup)((Object)this.workerGroup)).executorCount() : 1;
        int bind = 0;
        while (bind < binds) {
            int finalBind = bind++;
            Future f = bootstrap.bind().addListener(future -> {
                Channel channel = future.channel();
                if (future.isSuccess()) {
                    this.endpoints.put(address, new Endpoint(channel, ListenerType.MINECRAFT));
                    LOGGER.info("Listening on {}", (Object)channel.localAddress());
                    if (finalBind == 0) {
                        if (this.server.getConfiguration().isProxyProtocol()) {
                            LOGGER.warn("Using HAProxy and listening on {}, please ensure this listener is adequately firewalled.", (Object)channel.localAddress());
                        }
                        this.server.getEventManager().fireAndForget(new ListenerBoundEvent(address, ListenerType.MINECRAFT));
                    }
                } else {
                    LOGGER.error("Can't bind to {}", (Object)address, (Object)future.cause());
                }
            });
            f.syncUninterruptibly();
            if (!f.isSuccess()) break;
        }
    }

    public void queryBind(String hostname, int port) {
        InetSocketAddress address = new InetSocketAddress(hostname, port);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(this.transportType.datagramChannelFactory)).group(this.workerGroup)).handler(new GameSpyQueryHandler(this.server))).localAddress(address);
        bootstrap.bind().addListener(future -> {
            Channel channel = future.channel();
            if (future.isSuccess()) {
                this.endpoints.put(address, new Endpoint(channel, ListenerType.QUERY));
                LOGGER.info("Listening for GS4 query on {}", (Object)channel.localAddress());
                this.server.getEventManager().fireAndForget(new ListenerBoundEvent(address, ListenerType.QUERY));
            } else {
                LOGGER.error("Can't bind to {}", (Object)bootstrap.config().localAddress(), (Object)future.cause());
            }
        });
    }

    public Bootstrap createWorker(@Nullable EventLoopGroup group) {
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(this.transportType.socketChannelFactory)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.server.getConfiguration().getConnectTimeout())).group(group == null ? this.workerGroup : group)).resolver(this.resolver.asGroup());
        if (this.server.getConfiguration().useTcpFastOpen()) {
            bootstrap.option(ChannelOption.TCP_FASTOPEN_CONNECT, true);
        }
        return bootstrap;
    }

    public void close(InetSocketAddress oldBind) {
        Collection<Endpoint> endpoints = this.endpoints.removeAll(oldBind);
        Preconditions.checkState(!endpoints.isEmpty(), "Endpoint was not registered");
        ListenerType type = endpoints.iterator().next().getType();
        this.server.getEventManager().fire(new ListenerCloseEvent(oldBind, type)).join();
        for (Endpoint endpoint : endpoints) {
            Channel serverChannel = endpoint.getChannel();
            LOGGER.info("Closing endpoint {}", (Object)serverChannel.localAddress());
            serverChannel.close().syncUninterruptibly();
        }
    }

    public void closeEndpoints(boolean interrupt) {
        for (Map.Entry<InetSocketAddress, Collection<Endpoint>> entry : this.endpoints.asMap().entrySet()) {
            InetSocketAddress address = entry.getKey();
            Collection<Endpoint> endpoints = entry.getValue();
            ListenerType type = endpoints.iterator().next().getType();
            this.server.getEventManager().fire(new ListenerCloseEvent(address, type)).join();
            for (Endpoint endpoint : endpoints) {
                LOGGER.info("Closing endpoint {}", (Object)address);
                if (interrupt) {
                    try {
                        endpoint.getChannel().close().sync();
                    }
                    catch (InterruptedException e) {
                        LOGGER.info("Interrupted whilst closing endpoint", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                endpoint.getChannel().close().syncUninterruptibly();
            }
        }
        this.endpoints.clear();
    }

    public void shutdown() {
        this.closeEndpoints(true);
        this.resolver.shutdown();
    }

    public EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    public ServerChannelInitializerHolder getServerChannelInitializer() {
        return this.serverChannelInitializer;
    }

    public HttpClient createHttpClient() {
        return HttpClient.newBuilder().executor(this.workerGroup).build();
    }

    public BackendChannelInitializerHolder getBackendChannelInitializer() {
        return this.backendChannelInitializer;
    }
}

