/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandResult;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.api.event.command.PostCommandInvocationEvent;
import com.velocitypowered.api.plugin.PluginManager;
import com.velocitypowered.proxy.command.CommandGraphInjector;
import com.velocitypowered.proxy.command.SuggestionsProvider;
import com.velocitypowered.proxy.command.VelocityCommandMeta;
import com.velocitypowered.proxy.command.VelocityCommands;
import com.velocitypowered.proxy.command.brigadier.VelocityBrigadierCommandWrapper;
import com.velocitypowered.proxy.command.registrar.BrigadierCommandRegistrar;
import com.velocitypowered.proxy.command.registrar.CommandRegistrar;
import com.velocitypowered.proxy.command.registrar.RawCommandRegistrar;
import com.velocitypowered.proxy.command.registrar.SimpleCommandRegistrar;
import com.velocitypowered.proxy.event.VelocityEventManager;
import com.velocitypowered.proxy.plugin.virtual.VelocityVirtualPlugin;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class VelocityCommandManager
implements CommandManager {
    private final @GuardedBy(value={"lock"}) CommandDispatcher<CommandSource> dispatcher;
    private final ReadWriteLock lock;
    private final VelocityEventManager eventManager;
    private final List<CommandRegistrar<?>> registrars;
    private final SuggestionsProvider<CommandSource> suggestionsProvider;
    private final CommandGraphInjector<CommandSource> injector;
    private final Map<String, CommandMeta> commandMetas;
    private final PluginManager pluginManager;

    public VelocityCommandManager(VelocityEventManager eventManager, PluginManager pluginManager) {
        this.pluginManager = pluginManager;
        this.lock = new ReentrantReadWriteLock();
        this.dispatcher = new CommandDispatcher();
        this.eventManager = Preconditions.checkNotNull(eventManager);
        RootCommandNode<CommandSource> root = this.dispatcher.getRoot();
        this.registrars = ImmutableList.of(new BrigadierCommandRegistrar(root, this.lock.writeLock()), new SimpleCommandRegistrar(root, this.lock.writeLock()), new RawCommandRegistrar(root, this.lock.writeLock()));
        this.suggestionsProvider = new SuggestionsProvider<CommandSource>(this.dispatcher, this.lock.readLock());
        this.injector = new CommandGraphInjector<CommandSource>(this.dispatcher, this.lock.readLock());
        this.commandMetas = new ConcurrentHashMap<String, CommandMeta>();
    }

    public void setAnnounceProxyCommands(boolean announceProxyCommands) {
        this.suggestionsProvider.setAnnounceProxyCommands(announceProxyCommands);
    }

    @Override
    public CommandMeta.Builder metaBuilder(String alias) {
        Preconditions.checkNotNull(alias, "alias");
        return new VelocityCommandMeta.Builder(alias);
    }

    @Override
    public CommandMeta.Builder metaBuilder(BrigadierCommand command) {
        Preconditions.checkNotNull(command, "command");
        return new VelocityCommandMeta.Builder(command.getNode().getName());
    }

    @Override
    public void register(BrigadierCommand command) {
        Preconditions.checkNotNull(command, "command");
        this.register(this.metaBuilder(command).build(), command);
    }

    @Override
    public void register(CommandMeta meta, com.velocitypowered.api.command.Command command) {
        Preconditions.checkNotNull(meta, "meta");
        Preconditions.checkNotNull(command, "command");
        List<CommandRegistrar<?>> commandRegistrars = this.implementedRegistrars(command);
        if (commandRegistrars.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(command) + " does not implement a registrable Command subinterface");
        }
        if (commandRegistrars.size() > 1) {
            String implementedInterfaces = commandRegistrars.stream().map(CommandRegistrar::registrableSuperInterface).map(Class::getSimpleName).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.valueOf(command) + " implements multiple registrable Command subinterfaces: " + implementedInterfaces);
        }
        this.internalRegister(commandRegistrars.get(0), command, meta);
    }

    private <T extends com.velocitypowered.api.command.Command> void internalRegister(CommandRegistrar<T> registrar, com.velocitypowered.api.command.Command command, CommandMeta meta) {
        Class<T> superInterface = registrar.registrableSuperInterface();
        registrar.register(meta, (com.velocitypowered.api.command.Command)superInterface.cast(command));
        for (String alias : meta.getAliases()) {
            this.commandMetas.put(alias, meta);
        }
    }

    private List<CommandRegistrar<?>> implementedRegistrars(com.velocitypowered.api.command.Command command) {
        ArrayList registrarsFound = new ArrayList(2);
        for (CommandRegistrar<?> registrar : this.registrars) {
            Class<?> superInterface = registrar.registrableSuperInterface();
            if (!superInterface.isInstance(command)) continue;
            registrarsFound.add(registrar);
        }
        return registrarsFound;
    }

    @Override
    public void unregister(String alias) {
        Preconditions.checkNotNull(alias, "alias");
        this.lock.writeLock().lock();
        try {
            this.dispatcher.getRoot().removeChildByName(alias.toLowerCase(Locale.ENGLISH));
            this.commandMetas.remove(alias);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(CommandMeta meta) {
        Preconditions.checkNotNull(meta, "meta");
        this.lock.writeLock().lock();
        try {
            for (String alias : meta.getAliases()) {
                String lowercased = alias.toLowerCase(Locale.ENGLISH);
                if (!this.commandMetas.remove(lowercased, meta)) continue;
                this.dispatcher.getRoot().removeChildByName(lowercased);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public @Nullable CommandMeta getCommandMeta(String alias) {
        Preconditions.checkNotNull(alias, "alias");
        return this.commandMetas.get(alias);
    }

    public CompletableFuture<CommandExecuteEvent> callCommandEvent(CommandSource source, String cmdLine, CommandExecuteEvent.InvocationInfo invocationInfo) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        return this.eventManager.fire(new CommandExecuteEvent(source, cmdLine, invocationInfo));
    }

    private boolean executeImmediately0(CommandSource source, ParseResults<CommandSource> parsed) {
        Preconditions.checkNotNull(source, "source");
        CommandResult result = CommandResult.EXCEPTION;
        try {
            boolean executed = this.dispatcher.execute(parsed) != -165120983;
            result = executed ? CommandResult.EXECUTED : CommandResult.FORWARDED;
            boolean bl = executed;
            return bl;
        }
        catch (CommandSyntaxException e) {
            boolean isSyntaxError;
            boolean bl = isSyntaxError = !e.getType().equals(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand());
            if (isSyntaxError) {
                Message message = e.getRawMessage();
                if (message instanceof ComponentLike) {
                    ComponentLike componentLike = (ComponentLike)((Object)message);
                    source.sendMessage(componentLike.asComponent().applyFallbackStyle(NamedTextColor.RED));
                } else {
                    source.sendMessage(Component.text(e.getMessage(), (TextColor)NamedTextColor.RED));
                }
                result = CommandResult.SYNTAX_ERROR;
                boolean bl2 = true;
                return bl2;
            }
            result = CommandResult.FORWARDED;
            boolean bl3 = false;
            return bl3;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to invoke command " + parsed.getReader().getString() + " for " + String.valueOf(source), e);
        }
        finally {
            this.eventManager.fireAndForget(new PostCommandInvocationEvent(source, parsed.getReader().getString(), result));
        }
    }

    @Override
    public CompletableFuture<Boolean> executeAsync(CommandSource source, String cmdLine) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        CommandExecuteEvent.InvocationInfo invocationInfo = new CommandExecuteEvent.InvocationInfo(CommandExecuteEvent.SignedState.UNSUPPORTED, CommandExecuteEvent.Source.API);
        return this.callCommandEvent(source, cmdLine, invocationInfo).thenComposeAsync(event -> {
            CommandExecuteEvent.CommandResult commandResult = event.getResult();
            if (commandResult.isForwardToServer() || !commandResult.isAllowed()) {
                return CompletableFuture.completedFuture(false);
            }
            ParseResults<CommandSource> parsed = this.parse(commandResult.getCommand().orElse(cmdLine), source);
            return CompletableFuture.supplyAsync(() -> this.executeImmediately0(source, parsed), this.getAsyncExecutor(parsed));
        }, this.figureAsyncExecutorForParsing());
    }

    @Override
    public CompletableFuture<Boolean> executeImmediatelyAsync(CommandSource source, String cmdLine) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        return CompletableFuture.supplyAsync(() -> this.parse(cmdLine, source), this.figureAsyncExecutorForParsing()).thenCompose(parsed -> CompletableFuture.supplyAsync(() -> this.executeImmediately0(source, (ParseResults<CommandSource>)parsed), this.getAsyncExecutor((ParseResults<CommandSource>)parsed)));
    }

    @Override
    public CompletableFuture<List<String>> offerSuggestions(CommandSource source, String cmdLine) {
        return this.offerBrigadierSuggestions(source, cmdLine).thenApply(suggestions -> Lists.transform(suggestions.getList(), Suggestion::getText));
    }

    @Override
    public CompletableFuture<Suggestions> offerBrigadierSuggestions(CommandSource source, String cmdLine) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(cmdLine, "cmdLine");
        String normalizedInput = VelocityCommands.normalizeInput(cmdLine, false);
        try {
            return this.suggestionsProvider.provideSuggestions(normalizedInput, source);
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(new RuntimeException("Unable to provide suggestions for " + cmdLine + " for " + String.valueOf(source), e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResults<CommandSource> parse(String input, CommandSource source) {
        String normalizedInput = VelocityCommands.normalizeInput(input, true);
        this.lock.readLock().lock();
        try {
            ParseResults<CommandSource> parseResults = this.dispatcher.parse(normalizedInput, source);
            return parseResults;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<String> getAliases() {
        this.lock.readLock().lock();
        try {
            Collection collection = this.dispatcher.getRoot().getChildren().stream().map(CommandNode::getName).collect(ImmutableList.toImmutableList());
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean hasCommand(String alias) {
        return this.getCommand(alias) != null;
    }

    @Override
    public boolean hasCommand(String alias, CommandSource source) {
        Preconditions.checkNotNull(source, "source");
        CommandNode<CommandSource> command = this.getCommand(alias);
        return command != null && command.canUse(source);
    }

    CommandNode<CommandSource> getCommand(String alias) {
        Preconditions.checkNotNull(alias, "alias");
        return this.dispatcher.getRoot().getChild(alias.toLowerCase(Locale.ENGLISH));
    }

    @VisibleForTesting
    RootCommandNode<CommandSource> getRoot() {
        return this.dispatcher.getRoot();
    }

    public CommandGraphInjector<CommandSource> getInjector() {
        return this.injector;
    }

    private Executor getAsyncExecutor(ParseResults<CommandSource> parse) {
        VelocityBrigadierCommandWrapper vbcw;
        Command<CommandSource> command = parse.getContext().getCommand();
        Object registrant = command instanceof VelocityBrigadierCommandWrapper ? ((vbcw = (VelocityBrigadierCommandWrapper)command).registrant() == null ? VelocityVirtualPlugin.INSTANCE : vbcw.registrant()) : VelocityVirtualPlugin.INSTANCE;
        return this.pluginManager.ensurePluginContainer(registrant).getExecutorService();
    }

    private Executor figureAsyncExecutorForParsing() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            return this.pluginManager.ensurePluginContainer(VelocityVirtualPlugin.INSTANCE).getExecutorService();
        }
        return MoreExecutors.directExecutor();
    }
}

