/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class VelocityCommandMeta
implements CommandMeta {
    private final Set<String> aliases;
    private final List<CommandNode<CommandSource>> hints;
    private final Object plugin;

    private static CommandNode<CommandSource> copyForHinting(CommandNode<CommandSource> hint) {
        Object builder = hint.createBuilder().requires(source -> false);
        for (CommandNode<CommandSource> child : hint.getChildren()) {
            ((ArgumentBuilder)builder).then(VelocityCommandMeta.copyForHinting(child));
        }
        return ((ArgumentBuilder)builder).build();
    }

    public static Stream<CommandNode<CommandSource>> copyHints(CommandMeta meta) {
        return meta.getHints().stream().map(VelocityCommandMeta::copyForHinting);
    }

    private VelocityCommandMeta(Set<String> aliases, List<CommandNode<CommandSource>> hints, @Nullable Object plugin) {
        this.aliases = aliases;
        this.hints = hints;
        this.plugin = plugin;
    }

    @Override
    public Collection<String> getAliases() {
        return this.aliases;
    }

    @Override
    public Collection<CommandNode<CommandSource>> getHints() {
        return this.hints;
    }

    @Override
    public @Nullable Object getPlugin() {
        return this.plugin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VelocityCommandMeta that = (VelocityCommandMeta)o;
        if (!this.aliases.equals(that.aliases)) {
            return false;
        }
        return this.hints.equals(that.hints);
    }

    public int hashCode() {
        int result = this.aliases.hashCode();
        result = 31 * result + this.hints.hashCode();
        return result;
    }

    static final class Builder
    implements CommandMeta.Builder {
        private final ImmutableSet.Builder<String> aliases;
        private final ImmutableList.Builder<CommandNode<CommandSource>> hints;
        private @MonotonicNonNull Object plugin;

        public Builder(String alias) {
            Preconditions.checkNotNull(alias, "alias");
            this.aliases = ImmutableSet.builder().add(alias.toLowerCase(Locale.ENGLISH));
            this.hints = ImmutableList.builder();
            this.plugin = null;
        }

        @Override
        public CommandMeta.Builder aliases(String ... aliases) {
            Preconditions.checkNotNull(aliases, "aliases");
            int length = aliases.length;
            for (int i = 0; i < length; ++i) {
                String alias = aliases[i];
                Preconditions.checkNotNull(alias, "alias at index %s", i);
                this.aliases.add((Object)alias.toLowerCase(Locale.ENGLISH));
            }
            return this;
        }

        @Override
        public CommandMeta.Builder hint(CommandNode<CommandSource> node) {
            Preconditions.checkNotNull(node, "node");
            if (node.getCommand() != null) {
                throw new IllegalArgumentException("Cannot use executable node for hinting");
            }
            if (node.getRedirect() != null) {
                throw new IllegalArgumentException("Cannot use a node with a redirect for hinting");
            }
            this.hints.add((Object)node);
            return this;
        }

        @Override
        public CommandMeta.Builder plugin(Object plugin) {
            Preconditions.checkNotNull(plugin, "plugin");
            this.plugin = plugin;
            return this;
        }

        @Override
        public CommandMeta build() {
            return new VelocityCommandMeta((Set<String>)((Object)this.aliases.build()), (List<CommandNode<CommandSource>>)((Object)this.hints.build()), this.plugin);
        }
    }
}

