/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.legacy;

import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.chat.ChatHandler;
import com.velocitypowered.proxy.protocol.packet.chat.legacy.LegacyChatPacket;

public class LegacyChatHandler
implements ChatHandler<LegacyChatPacket> {
    private final VelocityServer server;
    private final ConnectedPlayer player;

    public LegacyChatHandler(VelocityServer server, ConnectedPlayer player) {
        this.server = server;
        this.player = player;
    }

    @Override
    public Class<LegacyChatPacket> packetClass() {
        return LegacyChatPacket.class;
    }

    @Override
    public void handlePlayerChatInternal(LegacyChatPacket packet) {
        MinecraftConnection serverConnection = this.player.ensureAndGetCurrentServer().ensureConnected();
        if (serverConnection == null) {
            return;
        }
        this.server.getEventManager().fire(new PlayerChatEvent(this.player, packet.getMessage())).whenComplete((chatEvent, throwable) -> {
            if (!chatEvent.getResult().isAllowed()) {
                return;
            }
            serverConnection.write(this.player.getChatBuilderFactory().builder().message(chatEvent.getResult().getMessage().orElse(packet.getMessage())).toServer());
        });
    }
}

