/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.server;

import com.velocitypowered.api.network.HandshakeIntent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.HandshakePacket;
import com.velocitypowered.proxy.protocol.packet.StatusRequestPacket;
import com.velocitypowered.proxy.protocol.packet.StatusResponsePacket;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class PingSessionHandler
implements MinecraftSessionHandler {
    private final CompletableFuture<ServerPing> result;
    private final RegisteredServer server;
    private final MinecraftConnection connection;
    private final ProtocolVersion version;
    private boolean completed = false;
    private final String virtualHostString;

    PingSessionHandler(CompletableFuture<ServerPing> result, RegisteredServer server, MinecraftConnection connection, ProtocolVersion version, String virtualHostString) {
        this.result = result;
        this.server = server;
        this.connection = connection;
        this.version = version;
        this.virtualHostString = virtualHostString;
    }

    @Override
    public void activated() {
        HandshakePacket handshake = new HandshakePacket();
        handshake.setIntent(HandshakeIntent.STATUS);
        handshake.setServerAddress(this.virtualHostString == null || this.virtualHostString.isEmpty() ? this.server.getServerInfo().getAddress().getHostString() : this.virtualHostString);
        handshake.setPort(this.server.getServerInfo().getAddress().getPort());
        handshake.setProtocolVersion(this.version);
        this.connection.delayedWrite(handshake);
        this.connection.setActiveSessionHandler(StateRegistry.STATUS);
        this.connection.setState(StateRegistry.STATUS);
        this.connection.delayedWrite(StatusRequestPacket.INSTANCE);
        this.connection.flush();
    }

    @Override
    public boolean handle(StatusResponsePacket packet) {
        this.completed = true;
        this.connection.close(true);
        ServerPing ping = VelocityServer.getPingGsonInstance(this.version).fromJson(packet.getStatus(), ServerPing.class);
        this.result.complete(ping);
        return true;
    }

    @Override
    public void disconnected() {
        if (!this.completed) {
            this.result.completeExceptionally(new IOException("Unexpectedly disconnected from remote server"));
        }
    }

    @Override
    public void exception(Throwable throwable) {
        this.completed = true;
        this.result.completeExceptionally(throwable);
    }
}

