/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;

@Plugin(name="stripAnsi", category="Converter")
@ConverterKeys(value={"stripAnsi"})
public class StripAnsiConverter
extends LogEventPatternConverter {
    private static final Pattern ANSI_PATTERN = Pattern.compile("\u001b\\[[;\\d]*m");
    private final List<PatternFormatter> formatters;

    protected StripAnsiConverter(List<PatternFormatter> formatters) {
        super("stripAnsi", null);
        this.formatters = formatters;
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        int start = toAppendTo.length();
        for (PatternFormatter formatter : this.formatters) {
            formatter.format(event, toAppendTo);
        }
        String content = toAppendTo.substring(start);
        content = ANSI_PATTERN.matcher(content).replaceAll("");
        toAppendTo.setLength(start);
        toAppendTo.append(content);
    }

    public static StripAnsiConverter newInstance(Configuration config, String[] options) {
        if (options.length != 1) {
            LOGGER.error("Incorrect number of options on stripFormat. Expected 1 received " + options.length);
            return null;
        }
        PatternParser parser = PatternLayout.createPatternParser(config);
        List<PatternFormatter> formatters = parser.parse(options[0]);
        return new StripAnsiConverter(formatters);
    }
}

