/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.gson;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationVisitor;
import org.checkerframework.checker.nullness.qual.Nullable;

class GsonVisitor
implements ConfigurationVisitor<JsonWriter, Void, IOException> {
    static ThreadLocal<GsonVisitor> INSTANCE = ThreadLocal.withInitial(GsonVisitor::new);
    private ConfigurationNode start;

    GsonVisitor() {
    }

    @Override
    public JsonWriter newState() {
        throw new UnsupportedOperationException("Writer must be provided");
    }

    @Override
    public void beginVisit(ConfigurationNode node, JsonWriter state) throws IOException {
        if (node.isEmpty()) {
            state.beginObject();
            state.endObject();
        } else {
            this.start = node;
        }
    }

    @Override
    public void enterNode(ConfigurationNode node, JsonWriter state) throws IOException {
        @Nullable ConfigurationNode parent = node.getParent();
        if (node != this.start && parent != null && parent.isMap()) {
            state.name(Objects.requireNonNull(node.getKey(), "Node must have key to be a value in a mapping").toString());
        }
    }

    @Override
    public void enterMappingNode(ConfigurationNode node, JsonWriter state) throws IOException {
        state.beginObject();
    }

    @Override
    public void enterListNode(ConfigurationNode node, JsonWriter state) throws IOException {
        state.beginArray();
    }

    @Override
    public void enterScalarNode(ConfigurationNode node, JsonWriter writer) throws IOException {
        @Nullable Object value = node.getValue();
        if (value == null) {
            writer.nullValue();
        } else if (value instanceof Double) {
            writer.value((Double)value);
        } else if (value instanceof Float) {
            writer.value((Float)value);
        } else if (value instanceof Long) {
            writer.value((Long)value);
        } else if (value instanceof Integer) {
            writer.value((Integer)value);
        } else if (value instanceof Boolean) {
            writer.value((Boolean)value);
        } else {
            writer.value(value.toString());
        }
    }

    @Override
    public void exitMappingNode(ConfigurationNode node, JsonWriter state) throws IOException {
        state.endObject();
    }

    @Override
    public void exitListNode(ConfigurationNode node, JsonWriter state) throws IOException {
        state.endArray();
    }

    @Override
    public Void endVisit(JsonWriter state) throws IOException {
        state.flush();
        this.start = null;
        return null;
    }
}

