/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Array;
import java.util.function.Predicate;
import ninja.leaping.configurate.Types;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.AbstractListChildSerializer;
import ninja.leaping.configurate.util.CheckedConsumer;

abstract class ArraySerializer<T>
extends AbstractListChildSerializer<T> {
    ArraySerializer() {
    }

    @Override
    TypeToken<?> getElementType(TypeToken<?> containerType) throws ObjectMappingException {
        return containerType.getComponentType();
    }

    static class Doubles
    extends ArraySerializer<double[]> {
        Doubles() {
        }

        @Override
        double[] createNew(int length, TypeToken<?> elementType) throws ObjectMappingException {
            return new double[length];
        }

        @Override
        void forEachElement(double[] collection, CheckedConsumer<Object, ObjectMappingException> action) throws ObjectMappingException {
            for (double b : collection) {
                action.accept(b);
            }
        }

        @Override
        void deserializeSingle(int index, double[] collection, Object deserialized) throws ObjectMappingException {
            Double ret = Types.asDouble(deserialized);
            collection[index] = ret == null ? 0.0 : ret;
        }
    }

    static class Floats
    extends ArraySerializer<float[]> {
        Floats() {
        }

        @Override
        float[] createNew(int length, TypeToken<?> elementType) throws ObjectMappingException {
            return new float[length];
        }

        @Override
        void forEachElement(float[] collection, CheckedConsumer<Object, ObjectMappingException> action) throws ObjectMappingException {
            for (float b : collection) {
                action.accept(Float.valueOf(b));
            }
        }

        @Override
        void deserializeSingle(int index, float[] collection, Object deserialized) throws ObjectMappingException {
            Float ret = Types.asFloat(deserialized);
            collection[index] = ret == null ? 0.0f : ret.floatValue();
        }
    }

    static class Longs
    extends ArraySerializer<long[]> {
        Longs() {
        }

        @Override
        long[] createNew(int length, TypeToken<?> elementType) throws ObjectMappingException {
            return new long[length];
        }

        @Override
        void forEachElement(long[] collection, CheckedConsumer<Object, ObjectMappingException> action) throws ObjectMappingException {
            for (long b : collection) {
                action.accept(b);
            }
        }

        @Override
        void deserializeSingle(int index, long[] collection, Object deserialized) throws ObjectMappingException {
            Long ret = Types.asLong(deserialized);
            collection[index] = ret == null ? 0L : ret;
        }
    }

    static class Ints
    extends ArraySerializer<int[]> {
        Ints() {
        }

        @Override
        int[] createNew(int length, TypeToken<?> elementType) throws ObjectMappingException {
            return new int[length];
        }

        @Override
        void forEachElement(int[] collection, CheckedConsumer<Object, ObjectMappingException> action) throws ObjectMappingException {
            for (int b : collection) {
                action.accept(b);
            }
        }

        @Override
        void deserializeSingle(int index, int[] collection, Object deserialized) throws ObjectMappingException {
            Integer ret = Types.asInt(deserialized);
            collection[index] = ret == null ? 0 : ret;
        }
    }

    static class Shorts
    extends ArraySerializer<short[]> {
        Shorts() {
        }

        @Override
        TypeToken<?> getElementType(TypeToken<?> containerType) throws ObjectMappingException {
            return containerType.getComponentType();
        }

        @Override
        short[] createNew(int length, TypeToken<?> elementType) throws ObjectMappingException {
            return new short[length];
        }

        @Override
        void forEachElement(short[] collection, CheckedConsumer<Object, ObjectMappingException> action) throws ObjectMappingException {
            for (short b : collection) {
                action.accept(b);
            }
        }

        @Override
        void deserializeSingle(int index, short[] collection, Object deserialized) throws ObjectMappingException {
            Integer ret = Types.asInt(deserialized);
            collection[index] = ret == null ? (short)0 : ret.shortValue();
        }
    }

    static class Chars
    extends ArraySerializer<char[]> {
        Chars() {
        }

        @Override
        char[] createNew(int length, TypeToken<?> elementType) throws ObjectMappingException {
            return new char[length];
        }

        @Override
        void forEachElement(char[] collection, CheckedConsumer<Object, ObjectMappingException> action) throws ObjectMappingException {
            for (char b : collection) {
                action.accept(Character.valueOf(b));
            }
        }

        @Override
        void deserializeSingle(int index, char[] collection, Object deserialized) throws ObjectMappingException {
            if (!(deserialized instanceof Character)) {
                throw new ObjectMappingException("Deserialized value must be a Character at index " + index);
            }
            collection[index] = ((Character)deserialized).charValue();
        }
    }

    static class Bytes
    extends ArraySerializer<byte[]> {
        Bytes() {
        }

        @Override
        byte[] createNew(int length, TypeToken<?> elementType) throws ObjectMappingException {
            return new byte[length];
        }

        @Override
        void forEachElement(byte[] collection, CheckedConsumer<Object, ObjectMappingException> action) throws ObjectMappingException {
            for (byte b : collection) {
                action.accept(b);
            }
        }

        @Override
        void deserializeSingle(int index, byte[] collection, Object deserialized) throws ObjectMappingException {
            Integer ret = Types.asInt(deserialized);
            collection[index] = ret == null ? (byte)0 : ret.byteValue();
        }
    }

    static class Booleans
    extends ArraySerializer<boolean[]> {
        Booleans() {
        }

        @Override
        boolean[] createNew(int length, TypeToken<?> elementType) throws ObjectMappingException {
            return new boolean[length];
        }

        @Override
        void forEachElement(boolean[] collection, CheckedConsumer<Object, ObjectMappingException> action) throws ObjectMappingException {
            for (boolean b : collection) {
                action.accept(b);
            }
        }

        @Override
        void deserializeSingle(int index, boolean[] collection, Object deserialized) throws ObjectMappingException {
            Boolean ret = Types.asBoolean(deserialized);
            collection[index] = ret == null ? false : ret;
        }
    }

    static class Objects
    extends ArraySerializer<Object[]> {
        Objects() {
        }

        public static Predicate<TypeToken<Object[]>> predicate() {
            return token -> {
                TypeToken<?> componentType = token.getComponentType();
                return componentType != null && !componentType.isPrimitive();
            };
        }

        @Override
        Object[] createNew(int length, TypeToken<?> elementType) throws ObjectMappingException {
            return (Object[])Array.newInstance(elementType.getRawType(), length);
        }

        @Override
        void forEachElement(Object[] collection, CheckedConsumer<Object, ObjectMappingException> action) throws ObjectMappingException {
            for (Object o : collection) {
                action.accept(o);
            }
        }

        @Override
        void deserializeSingle(int index, Object[] collection, Object deserialized) throws ObjectMappingException {
            collection[index] = deserialized;
        }
    }
}

