/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.player.resourcepack;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import io.netty.buffer.ByteBufUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.kyori.adventure.resource.ResourcePackInfoLike;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public final class VelocityResourcePackInfo
implements ResourcePackInfo {
    private final UUID id;
    private final String url;
    private final byte @Nullable [] hash;
    private final boolean shouldForce;
    private final @Nullable Component prompt;
    private final ResourcePackInfo.Origin origin;
    private ResourcePackInfo.Origin originalOrigin;

    private VelocityResourcePackInfo(UUID id, String url, byte @Nullable [] hash, boolean shouldForce, @Nullable Component prompt, ResourcePackInfo.Origin origin) {
        this.id = id;
        this.url = url;
        this.hash = hash;
        this.shouldForce = shouldForce;
        this.prompt = prompt;
        this.origin = origin;
        this.originalOrigin = origin;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public @Nullable Component getPrompt() {
        return this.prompt;
    }

    @Override
    public boolean getShouldForce() {
        return this.shouldForce;
    }

    @Override
    public byte @Nullable [] getHash() {
        return this.hash == null ? null : (byte[])this.hash.clone();
    }

    @Override
    public ResourcePackInfo.Origin getOrigin() {
        return this.origin;
    }

    public void setOriginalOrigin(ResourcePackInfo.Origin originalOrigin) {
        this.originalOrigin = originalOrigin;
    }

    @Override
    public ResourcePackInfo.Origin getOriginalOrigin() {
        return this.originalOrigin;
    }

    @Override
    public ResourcePackInfo.Builder asBuilder() {
        return new BuilderImpl(this.url).setId(this.id).setShouldForce(this.shouldForce).setHash(this.hash).setPrompt(this.prompt);
    }

    @Override
    public ResourcePackInfo.Builder asBuilder(String newUrl) {
        return new BuilderImpl(newUrl).setId(this.id).setShouldForce(this.shouldForce).setHash(this.hash).setPrompt(this.prompt);
    }

    @Override
    @NotNull
    public ResourcePackRequest asResourcePackRequest() {
        return (ResourcePackRequest)ResourcePackRequest.resourcePackRequest().packs(net.kyori.adventure.resource.ResourcePackInfo.resourcePackInfo().id(this.id).uri(URI.create(this.url)).hash(this.hash == null ? "" : ByteBufUtil.hexDump(this.hash)).build(), new ResourcePackInfoLike[0]).required(this.shouldForce).prompt(this.prompt).build();
    }

    public static ResourcePackInfo fromAdventureRequest(ResourcePackRequest request, net.kyori.adventure.resource.ResourcePackInfo pack) {
        return new BuilderImpl(pack.uri().toString()).setHash(pack.hash().isEmpty() ? null : ByteBufUtil.decodeHexDump(pack.hash())).setId(pack.id()).setShouldForce(request.required()).setPrompt(request.prompt()).build();
    }

    public static final class BuilderImpl
    implements ResourcePackInfo.Builder {
        private UUID id;
        private final String url;
        private boolean shouldForce;
        private byte @Nullable [] hash;
        private @Nullable Component prompt;
        private ResourcePackInfo.Origin origin = ResourcePackInfo.Origin.PLUGIN_ON_PROXY;

        public BuilderImpl(String url) {
            this.url = Preconditions.checkNotNull(url, "url");
            this.id = UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public BuilderImpl setId(UUID id) {
            this.id = id;
            return this;
        }

        @Override
        public BuilderImpl setShouldForce(boolean shouldForce) {
            this.shouldForce = shouldForce;
            return this;
        }

        @Override
        public BuilderImpl setHash(byte @Nullable [] hash) {
            if (hash != null) {
                Preconditions.checkArgument(hash.length == 20, "Hash length is not 20");
                this.hash = (byte[])hash.clone();
            } else {
                this.hash = null;
            }
            return this;
        }

        @Override
        public BuilderImpl setPrompt(@Nullable Component prompt) {
            this.prompt = prompt;
            return this;
        }

        @Override
        public ResourcePackInfo build() {
            return new VelocityResourcePackInfo(this.id, this.url, this.hash, this.shouldForce, this.prompt, this.origin);
        }

        public BuilderImpl setOrigin(ResourcePackInfo.Origin origin) {
            this.origin = origin;
            return this;
        }
    }
}

