/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.session;

import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.event.VelocityEventManager;
import com.velocitypowered.proxy.protocol.packet.chat.ChatHandler;
import com.velocitypowered.proxy.protocol.packet.chat.ChatQueue;
import com.velocitypowered.proxy.protocol.packet.chat.LastSeenMessages;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedChatHandler;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerChatPacket;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionChatHandler
implements ChatHandler<SessionPlayerChatPacket> {
    private static final Logger logger = LogManager.getLogger(SessionChatHandler.class);
    private final ConnectedPlayer player;
    private final VelocityServer server;

    public SessionChatHandler(ConnectedPlayer player, VelocityServer server) {
        this.player = player;
        this.server = server;
    }

    @Override
    public Class<SessionPlayerChatPacket> packetClass() {
        return SessionPlayerChatPacket.class;
    }

    @Override
    public void handlePlayerChatInternal(SessionPlayerChatPacket packet) {
        ChatQueue chatQueue = this.player.getChatQueue();
        VelocityEventManager eventManager = this.server.getEventManager();
        PlayerChatEvent toSend = new PlayerChatEvent(this.player, packet.getMessage());
        CompletableFuture<PlayerChatEvent> eventFuture = eventManager.fire(toSend);
        chatQueue.queuePacket(newLastSeenMessages -> ((CompletableFuture)eventFuture.thenApply(pme -> {
            PlayerChatEvent.ChatResult chatResult = pme.getResult();
            if (!chatResult.isAllowed()) {
                if (packet.isSigned()) {
                    KeyedChatHandler.invalidCancel(logger, this.player);
                }
                return null;
            }
            if (chatResult.getMessage().map(str -> !str.equals(packet.getMessage())).orElse(false).booleanValue()) {
                if (packet.isSigned()) {
                    KeyedChatHandler.invalidChange(logger, this.player);
                    return null;
                }
                return this.player.getChatBuilderFactory().builder().message(chatResult.getMessage().orElse(packet.getMessage())).setTimestamp(packet.timestamp).setLastSeenMessages((LastSeenMessages)newLastSeenMessages).toServer();
            }
            return packet.withLastSeenMessages((LastSeenMessages)newLastSeenMessages);
        })).exceptionally(ex -> {
            logger.error("Exception while handling player chat for {}", (Object)this.player, ex);
            return null;
        }), packet.getTimestamp(), packet.getLastSeenMessages());
    }
}

