/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.session;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ChatType;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import com.velocitypowered.proxy.protocol.packet.chat.LastSeenMessages;
import com.velocitypowered.proxy.protocol.packet.chat.SystemChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.builder.ChatBuilderV2;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerCommandPacket;
import com.velocitypowered.proxy.protocol.packet.chat.session.UnsignedPlayerCommandPacket;
import net.kyori.adventure.text.Component;

public class SessionChatBuilder
extends ChatBuilderV2 {
    public SessionChatBuilder(ProtocolVersion version) {
        super(version);
    }

    @Override
    public MinecraftPacket toClient() {
        Component msg = this.component == null ? Component.text(this.message) : this.component;
        return new SystemChatPacket(new ComponentHolder(this.version, msg), this.type == ChatType.CHAT ? ChatType.SYSTEM : this.type);
    }

    @Override
    public MinecraftPacket toServer() {
        LastSeenMessages lastSeenMessages;
        LastSeenMessages lastSeenMessages2 = lastSeenMessages = this.lastSeenMessages != null ? this.lastSeenMessages : new LastSeenMessages();
        if (this.message.startsWith("/")) {
            if (this.version.noLessThan(ProtocolVersion.MINECRAFT_1_20_5)) {
                UnsignedPlayerCommandPacket command = new UnsignedPlayerCommandPacket();
                command.command = this.message.substring(1);
                return command;
            }
            SessionPlayerCommandPacket command = new SessionPlayerCommandPacket();
            command.command = this.message.substring(1);
            command.salt = 0L;
            command.timeStamp = this.timestamp;
            command.argumentSignatures = new SessionPlayerCommandPacket.ArgumentSignatures();
            command.lastSeenMessages = lastSeenMessages;
            return command;
        }
        SessionPlayerChatPacket chat = new SessionPlayerChatPacket();
        chat.message = this.message;
        chat.signed = false;
        chat.signature = new byte[0];
        chat.timestamp = this.timestamp;
        chat.salt = 0L;
        chat.lastSeenMessages = lastSeenMessages;
        return chat;
    }
}

