/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.annotation.AwaitingEvent;
import com.velocitypowered.api.proxy.InboundConnection;
import com.velocitypowered.api.util.GameProfile;
import org.checkerframework.checker.nullness.qual.Nullable;

@AwaitingEvent
public final class GameProfileRequestEvent {
    private final String username;
    private final InboundConnection connection;
    private final GameProfile originalProfile;
    private final boolean onlineMode;
    private @Nullable GameProfile gameProfile;

    public GameProfileRequestEvent(InboundConnection connection, GameProfile originalProfile, boolean onlineMode) {
        this.connection = Preconditions.checkNotNull(connection, "connection");
        this.originalProfile = Preconditions.checkNotNull(originalProfile, "originalProfile");
        this.username = originalProfile.getName();
        this.onlineMode = onlineMode;
    }

    public InboundConnection getConnection() {
        return this.connection;
    }

    public String getUsername() {
        return this.username;
    }

    public GameProfile getOriginalProfile() {
        return this.originalProfile;
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile == null ? this.originalProfile : this.gameProfile;
    }

    public void setGameProfile(@Nullable GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    public String toString() {
        return "GameProfileRequestEvent{username=" + this.username + ", gameProfile=" + String.valueOf(this.gameProfile) + "}";
    }
}

