/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.adventure;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.velocitypowered.proxy.adventure.RegisteredCallback;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.event.ClickCallback;
import org.checkerframework.checker.index.qual.NonNegative;

public class ClickCallbackManager {
    public static final ClickCallbackManager INSTANCE = new ClickCallbackManager();
    static final String COMMAND = "/velocity:callback ";
    private final Cache<UUID, RegisteredCallback> registrations = Caffeine.newBuilder().expireAfter(new Expiry<UUID, RegisteredCallback>(this){

        @Override
        public long expireAfterCreate(UUID key, RegisteredCallback value, long currentTime) {
            return value.duration().toNanos();
        }

        @Override
        public long expireAfterUpdate(UUID key, RegisteredCallback value, long currentTime, @NonNegative long currentDuration) {
            return currentDuration;
        }

        @Override
        public long expireAfterRead(UUID key, RegisteredCallback value, long currentTime, @NonNegative long currentDuration) {
            AtomicInteger remainingUses = value.remainingUses();
            if (remainingUses != null && remainingUses.get() <= 0) {
                return 0L;
            }
            return currentDuration;
        }
    }).scheduler(Scheduler.systemScheduler()).build();

    private ClickCallbackManager() {
    }

    public boolean runCallback(Audience audience, UUID id) {
        RegisteredCallback callback = this.registrations.getIfPresent(id);
        if (callback != null && callback.tryUse()) {
            callback.callback().accept(audience);
            return true;
        }
        return false;
    }

    public UUID register(ClickCallback<Audience> callback, ClickCallback.Options options) {
        UUID id = UUID.randomUUID();
        RegisteredCallback registration = new RegisteredCallback(options.lifetime(), options.uses(), callback);
        this.registrations.put(id, registration);
        return id;
    }
}

