/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.reactive;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ninja.leaping.configurate.reactive.AbstractProcessor;
import ninja.leaping.configurate.reactive.Subscriber;
import ninja.leaping.configurate.reactive.TransactionFailedException;
import ninja.leaping.configurate.reactive.TransactionalProcessorImpl;
import ninja.leaping.configurate.reactive.TransactionalSubscriber;

interface TransactionalRegistration<V>
extends AbstractProcessor.Registration<V> {
    public TransactionalProcessorImpl<V> getHolder();

    @Override
    default public void dispose() {
        if (this.getHolder().registrations.remove(this)) {
            this.getHolder().subscriberCount.getAndDecrement();
        }
    }

    @Override
    default public void submit(V value) {
        try {
            this.beginTransaction(value);
            this.commit();
        }
        catch (TransactionFailedException ex) {
            this.rollback();
        }
    }

    public void beginTransaction(V var1) throws TransactionFailedException;

    public void commit();

    public void rollback();

    public static class Fully<V>
    implements TransactionalRegistration<V> {
        private final TransactionalProcessorImpl<V> holder;
        private final TransactionalSubscriber<? super V> sub;
        private final Lock lock = new ReentrantLock();

        Fully(TransactionalProcessorImpl<V> holder, TransactionalSubscriber<? super V> sub) {
            this.holder = holder;
            this.sub = sub;
        }

        @Override
        public TransactionalProcessorImpl<V> getHolder() {
            return this.holder;
        }

        @Override
        public void beginTransaction(V value) throws TransactionFailedException {
            this.lock.lock();
            this.sub.beginTransaction(value);
        }

        @Override
        public void commit() {
            try {
                this.sub.commit();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void rollback() {
            try {
                this.sub.rollback();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void onClose() {
            this.sub.onClose();
        }

        @Override
        public void onError(Throwable e) {
            this.sub.onError(e);
        }
    }

    public static class Wrapped<V>
    implements TransactionalRegistration<V> {
        private final AtomicReference<V> active = new AtomicReference();
        private final TransactionalProcessorImpl<V> holder;
        private final Subscriber<? super V> sub;

        Wrapped(TransactionalProcessorImpl<V> holder, Subscriber<? super V> sub) {
            this.holder = holder;
            this.sub = sub;
        }

        @Override
        public TransactionalProcessorImpl<V> getHolder() {
            return this.holder;
        }

        @Override
        public void beginTransaction(V value) {
            this.active.set(value);
        }

        @Override
        public void commit() {
            Object active = this.active.getAndSet(null);
            if (active != null) {
                this.sub.submit(active);
            }
        }

        @Override
        public void rollback() {
            this.active.set(null);
        }

        @Override
        public void onClose() {
            this.sub.onClose();
        }

        @Override
        public void onError(Throwable e) {
            this.sub.onError(e);
        }
    }
}

