/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import io.netty.buffer.ByteBuf;
import net.kyori.adventure.text.Component;

public class HeaderAndFooterPacket
implements MinecraftPacket {
    private final ComponentHolder header;
    private final ComponentHolder footer;

    public HeaderAndFooterPacket() {
        throw new UnsupportedOperationException("Decode is not implemented");
    }

    public HeaderAndFooterPacket(ComponentHolder header, ComponentHolder footer) {
        this.header = Preconditions.checkNotNull(header, "header");
        this.footer = Preconditions.checkNotNull(footer, "footer");
    }

    public ComponentHolder getHeader() {
        return this.header;
    }

    public ComponentHolder getFooter() {
        return this.footer;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        throw new UnsupportedOperationException("Decode is not implemented");
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.header.write(buf);
        this.footer.write(buf);
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public static HeaderAndFooterPacket create(Component header, Component footer, ProtocolVersion protocolVersion) {
        return new HeaderAndFooterPacket(new ComponentHolder(protocolVersion, header), new ComponentHolder(protocolVersion, footer));
    }

    public static HeaderAndFooterPacket reset(ProtocolVersion version) {
        ComponentHolder empty = new ComponentHolder(version, Component.empty());
        return new HeaderAndFooterPacket(empty, empty);
    }
}

