/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.crypto.IdentifiedKeyImpl;
import com.velocitypowered.proxy.protocol.netty.MinecraftDecoder;
import com.velocitypowered.proxy.protocol.util.NettyPreconditions;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.json.JSONOptions;
import net.kyori.adventure.text.serializer.json.legacyimpl.NBTLegacyHoverEventSerializer;
import net.kyori.option.OptionSchema;

public final class ProtocolUtils
extends Enum<ProtocolUtils> {
    private static final GsonComponentSerializer PRE_1_16_SERIALIZER;
    private static final GsonComponentSerializer PRE_1_20_3_SERIALIZER;
    private static final GsonComponentSerializer PRE_1_21_5_SERIALIZER;
    private static final GsonComponentSerializer MODERN_SERIALIZER;
    public static final int DEFAULT_MAX_STRING_SIZE = 65536;
    private static final int MAXIMUM_VARINT_SIZE = 5;
    private static final BinaryTagType<? extends BinaryTag>[] BINARY_TAG_TYPES;
    private static final QuietDecoderException BAD_VARINT_CACHED;
    private static final int[] VAR_INT_LENGTHS;
    private static final int FORGE_MAX_ARRAY_LENGTH = 2097050;
    private static final /* synthetic */ ProtocolUtils[] $VALUES;

    public static ProtocolUtils[] values() {
        return (ProtocolUtils[])$VALUES.clone();
    }

    public static ProtocolUtils valueOf(String name) {
        return Enum.valueOf(ProtocolUtils.class, name);
    }

    private static DecoderException badVarint() {
        return MinecraftDecoder.DEBUG ? new CorruptedFrameException("Bad VarInt decoded") : BAD_VARINT_CACHED;
    }

    public static int readVarInt(ByteBuf buf) {
        int readable = buf.readableBytes();
        if (readable == 0) {
            throw ProtocolUtils.badVarint();
        }
        byte k = buf.readByte();
        if ((k & 0x80) != 128) {
            return k;
        }
        int maxRead = Math.min(5, readable);
        int i = k & 0x7F;
        for (int j = 1; j < maxRead; ++j) {
            k = buf.readByte();
            i |= (k & 0x7F) << j * 7;
            if ((k & 0x80) == 128) continue;
            return i;
        }
        throw ProtocolUtils.badVarint();
    }

    public static int varIntBytes(int value) {
        return VAR_INT_LENGTHS[Integer.numberOfLeadingZeros(value)];
    }

    public static void writeVarInt(ByteBuf buf, int value) {
        if ((value & 0xFFFFFF80) == 0) {
            buf.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            buf.writeShort(w);
        } else {
            ProtocolUtils.writeVarIntFull(buf, value);
        }
    }

    private static void writeVarIntFull(ByteBuf buf, int value) {
        if ((value & 0xFFFFFF80) == 0) {
            buf.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            buf.writeShort(w);
        } else if ((value & 0xFFE00000) == 0) {
            int w = (value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14;
            buf.writeMedium(w);
        } else if ((value & 0xF0000000) == 0) {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21;
            buf.writeInt(w);
        } else {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80);
            buf.writeInt(w);
            buf.writeByte(value >>> 28);
        }
    }

    public static int encode21BitVarInt(int value) {
        return (value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14;
    }

    public static String readString(ByteBuf buf) {
        return ProtocolUtils.readString(buf, 65536);
    }

    public static String readString(ByteBuf buf, int cap) {
        int length = ProtocolUtils.readVarInt(buf);
        return ProtocolUtils.readString(buf, cap, length);
    }

    private static String readString(ByteBuf buf, int cap, int length) {
        NettyPreconditions.checkFrame(length >= 0, "Got a negative-length string (%s)", (Object)length);
        NettyPreconditions.checkFrame(length <= cap * 3, "Bad string size (got %s, maximum is %s)", (Object)length, (Object)cap);
        NettyPreconditions.checkFrame(buf.isReadable(length), "Trying to read a string that is too long (wanted %s, only have %s)", (Object)length, (Object)buf.readableBytes());
        String str = buf.readString(length, StandardCharsets.UTF_8);
        NettyPreconditions.checkFrame(str.length() <= cap, "Got a too-long string (got %s, max %s)", (Object)str.length(), (Object)cap);
        return str;
    }

    public static void writeString(ByteBuf buf, CharSequence str) {
        int size = ByteBufUtil.utf8Bytes(str);
        ProtocolUtils.writeVarInt(buf, size);
        buf.writeCharSequence(str, StandardCharsets.UTF_8);
    }

    public static Key readKey(ByteBuf buf) {
        return Key.key(ProtocolUtils.readString(buf), ':');
    }

    public static void writeKey(ByteBuf buf, Key key) {
        ProtocolUtils.writeString(buf, key.asString());
    }

    public static void writeMinimalKey(ByteBuf buf, Key key) {
        ProtocolUtils.writeString(buf, key.asMinimalString());
    }

    public static Key[] readKeyArray(ByteBuf buf) {
        int length = ProtocolUtils.readVarInt(buf);
        NettyPreconditions.checkFrame(length >= 0, "Got a negative-length array (%s)", (Object)length);
        NettyPreconditions.checkFrame(buf.isReadable(length), "Trying to read an array that is too long (wanted %s, only have %s)", (Object)length, (Object)buf.readableBytes());
        Key[] ret = new Key[length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ProtocolUtils.readKey(buf);
        }
        return ret;
    }

    public static void writeKeyArray(ByteBuf buf, Key[] keys) {
        ProtocolUtils.writeVarInt(buf, keys.length);
        for (Key key : keys) {
            ProtocolUtils.writeKey(buf, key);
        }
    }

    public static byte[] readByteArray(ByteBuf buf) {
        return ProtocolUtils.readByteArray(buf, 65536);
    }

    public static byte[] readByteArray(ByteBuf buf, int cap) {
        int length = ProtocolUtils.readVarInt(buf);
        NettyPreconditions.checkFrame(length >= 0, "Got a negative-length array (%s)", (Object)length);
        NettyPreconditions.checkFrame(length <= cap, "Bad array size (got %s, maximum is %s)", (Object)length, (Object)cap);
        NettyPreconditions.checkFrame(buf.isReadable(length), "Trying to read an array that is too long (wanted %s, only have %s)", (Object)length, (Object)buf.readableBytes());
        byte[] array = new byte[length];
        buf.readBytes(array);
        return array;
    }

    public static void writeByteArray(ByteBuf buf, byte[] array) {
        ProtocolUtils.writeVarInt(buf, array.length);
        buf.writeBytes(array);
    }

    public static int[] readIntegerArray(ByteBuf buf) {
        int len = ProtocolUtils.readVarInt(buf);
        Preconditions.checkArgument(len >= 0, "Got a negative-length integer array (%s)", len);
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ProtocolUtils.readVarInt(buf);
        }
        return array;
    }

    public static UUID readUuid(ByteBuf buf) {
        long msb = buf.readLong();
        long lsb = buf.readLong();
        return new UUID(msb, lsb);
    }

    public static void writeUuid(ByteBuf buf, UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID readUuidIntArray(ByteBuf buf) {
        long msbHigh = (long)buf.readInt() << 32;
        long msbLow = (long)buf.readInt() & 0xFFFFFFFFL;
        long msb = msbHigh | msbLow;
        long lsbHigh = (long)buf.readInt() << 32;
        long lsbLow = (long)buf.readInt() & 0xFFFFFFFFL;
        long lsb = lsbHigh | lsbLow;
        return new UUID(msb, lsb);
    }

    public static void writeUuidIntArray(ByteBuf buf, UUID uuid) {
        buf.writeInt((int)(uuid.getMostSignificantBits() >> 32));
        buf.writeInt((int)uuid.getMostSignificantBits());
        buf.writeInt((int)(uuid.getLeastSignificantBits() >> 32));
        buf.writeInt((int)uuid.getLeastSignificantBits());
    }

    public static CompoundBinaryTag readCompoundTag(ByteBuf buf, ProtocolVersion version, BinaryTagIO.Reader reader) {
        BinaryTag binaryTag = ProtocolUtils.readBinaryTag(buf, version, reader);
        if (binaryTag.type() != BinaryTagTypes.COMPOUND) {
            throw new DecoderException("Expected root tag to be CompoundTag, but is " + binaryTag.getClass().getSimpleName());
        }
        return (CompoundBinaryTag)binaryTag;
    }

    public static BinaryTag readBinaryTag(ByteBuf buf, ProtocolVersion version, BinaryTagIO.Reader reader) {
        BinaryTagType<? extends BinaryTag> type = BINARY_TAG_TYPES[buf.readByte()];
        if (version.lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
            buf.skipBytes(buf.readUnsignedShort());
        }
        try {
            return type.read(new ByteBufInputStream(buf));
        }
        catch (IOException thrown) {
            throw new DecoderException("Unable to parse BinaryTag, full error: " + thrown.getMessage());
        }
    }

    public static <T extends BinaryTag> void writeBinaryTag(ByteBuf buf, ProtocolVersion version, T tag) {
        BinaryTagType<? extends BinaryTag> type = tag.type();
        buf.writeByte(type.id());
        try {
            if (version.lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
                buf.writeShort(0);
            }
            type.write(tag, new ByteBufOutputStream(buf));
        }
        catch (IOException e) {
            throw new EncoderException("Unable to encode BinaryTag");
        }
    }

    public static String[] readStringArray(ByteBuf buf) {
        int length = ProtocolUtils.readVarInt(buf);
        String[] ret = new String[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = ProtocolUtils.readString(buf);
        }
        return ret;
    }

    public static void writeStringArray(ByteBuf buf, String[] stringArray) {
        ProtocolUtils.writeVarInt(buf, stringArray.length);
        for (String s : stringArray) {
            ProtocolUtils.writeString(buf, s);
        }
    }

    public static int[] readVarIntArray(ByteBuf buf) {
        int length = ProtocolUtils.readVarInt(buf);
        NettyPreconditions.checkFrame(length >= 0, "Got a negative-length array (%s)", (Object)length);
        NettyPreconditions.checkFrame(buf.isReadable(length), "Trying to read an array that is too long (wanted %s, only have %s)", (Object)length, (Object)buf.readableBytes());
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = ProtocolUtils.readVarInt(buf);
        }
        return ret;
    }

    public static void writeVarIntArray(ByteBuf buf, int[] intArray) {
        ProtocolUtils.writeVarInt(buf, intArray.length);
        for (int i = 0; i < intArray.length; ++i) {
            ProtocolUtils.writeVarInt(buf, intArray[i]);
        }
    }

    public static void writeProperties(ByteBuf buf, List<GameProfile.Property> properties) {
        ProtocolUtils.writeVarInt(buf, properties.size());
        for (GameProfile.Property property : properties) {
            ProtocolUtils.writeString(buf, property.getName());
            ProtocolUtils.writeString(buf, property.getValue());
            String signature = property.getSignature();
            if (signature != null && !signature.isEmpty()) {
                buf.writeBoolean(true);
                ProtocolUtils.writeString(buf, signature);
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public static List<GameProfile.Property> readProperties(ByteBuf buf) {
        ArrayList<GameProfile.Property> properties = new ArrayList<GameProfile.Property>();
        int size = ProtocolUtils.readVarInt(buf);
        for (int i = 0; i < size; ++i) {
            String name = ProtocolUtils.readString(buf);
            String value = ProtocolUtils.readString(buf);
            String signature = "";
            boolean hasSignature = buf.readBoolean();
            if (hasSignature) {
                signature = ProtocolUtils.readString(buf);
            }
            properties.add(new GameProfile.Property(name, value, signature));
        }
        return properties;
    }

    public static byte[] readByteArray17(ByteBuf buf) {
        int len = ProtocolUtils.readExtendedForgeShort(buf);
        Preconditions.checkArgument(len <= 2097050, "Cannot receive array longer than %s (got %s bytes)", 2097050, len);
        byte[] ret = new byte[len];
        buf.readBytes(ret);
        return ret;
    }

    public static ByteBuf readRetainedByteBufSlice17(ByteBuf buf) {
        int len = ProtocolUtils.readExtendedForgeShort(buf);
        NettyPreconditions.checkFrame(len <= 2097050, "Cannot receive array longer than %s (got %s bytes)", (Object)2097050, (Object)len);
        return buf.readRetainedSlice(len);
    }

    public static void writeByteArray17(byte[] b, ByteBuf buf, boolean allowExtended) {
        if (allowExtended) {
            NettyPreconditions.checkFrame(b.length <= 2097050, "Cannot send array longer than %s (got %s bytes)", (Object)2097050, (Object)b.length);
        } else {
            NettyPreconditions.checkFrame(b.length <= Short.MAX_VALUE, "Cannot send array longer than Short.MAX_VALUE (got %s bytes)", (Object)b.length);
        }
        ProtocolUtils.writeExtendedForgeShort(buf, b.length);
        buf.writeBytes(b);
    }

    public static void writeByteBuf17(ByteBuf b, ByteBuf buf, boolean allowExtended) {
        if (allowExtended) {
            NettyPreconditions.checkFrame(b.readableBytes() <= 2097050, "Cannot send array longer than %s (got %s bytes)", (Object)2097050, (Object)b.readableBytes());
        } else {
            NettyPreconditions.checkFrame(b.readableBytes() <= Short.MAX_VALUE, "Cannot send array longer than Short.MAX_VALUE (got %s bytes)", (Object)b.readableBytes());
        }
        ProtocolUtils.writeExtendedForgeShort(buf, b.readableBytes());
        buf.writeBytes(b);
    }

    public static int readExtendedForgeShort(ByteBuf buf) {
        int low = buf.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = buf.readUnsignedByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public static void writeExtendedForgeShort(ByteBuf buf, int toWrite) {
        int low = toWrite & Short.MAX_VALUE;
        int high = (toWrite & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        buf.writeShort(low);
        if (high != 0) {
            buf.writeByte(high);
        }
    }

    public static String readStringWithoutLength(ByteBuf buf) {
        return ProtocolUtils.readString(buf, 65536, buf.readableBytes());
    }

    public static GsonComponentSerializer getJsonChatSerializer(ProtocolVersion version) {
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_21_5)) {
            return MODERN_SERIALIZER;
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_3)) {
            return PRE_1_21_5_SERIALIZER;
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16)) {
            return PRE_1_20_3_SERIALIZER;
        }
        return PRE_1_16_SERIALIZER;
    }

    public static void writePlayerKey(ByteBuf buf, IdentifiedKey playerKey) {
        buf.writeLong(playerKey.getExpiryTemporal().toEpochMilli());
        ProtocolUtils.writeByteArray(buf, playerKey.getSignedPublicKey().getEncoded());
        ProtocolUtils.writeByteArray(buf, playerKey.getSignature());
    }

    public static IdentifiedKey readPlayerKey(ProtocolVersion version, ByteBuf buf) {
        long expiry = buf.readLong();
        byte[] key = ProtocolUtils.readByteArray(buf);
        byte[] signature = ProtocolUtils.readByteArray(buf, 4096);
        IdentifiedKey.Revision revision = version.noGreaterOrLessThan(ProtocolVersion.MINECRAFT_1_19) ? IdentifiedKey.Revision.GENERIC_V1 : IdentifiedKey.Revision.LINKED_V2;
        return new IdentifiedKeyImpl(revision, key, expiry, signature);
    }

    public static Sound.Source readSoundSource(ByteBuf buf, ProtocolVersion version) {
        int ordinal = ProtocolUtils.readVarInt(buf);
        if (version.lessThan(ProtocolVersion.MINECRAFT_1_21_5) && ordinal == Sound.Source.UI.ordinal()) {
            throw new UnsupportedOperationException("UI sound-source is only supported in 1.21.5+");
        }
        return Sound.Source.values()[ordinal];
    }

    public static void writeSoundSource(ByteBuf buf, ProtocolVersion version, Sound.Source source) {
        if (version.lessThan(ProtocolVersion.MINECRAFT_1_21_5) && source == Sound.Source.UI) {
            throw new UnsupportedOperationException("UI sound-source is only supported in 1.21.5+");
        }
        ProtocolUtils.writeVarInt(buf, source.ordinal());
    }

    private static /* synthetic */ ProtocolUtils[] $values() {
        return new ProtocolUtils[0];
    }

    static {
        $VALUES = ProtocolUtils.$values();
        PRE_1_16_SERIALIZER = GsonComponentSerializer.builder().downsampleColors().legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).options(OptionSchema.globalSchema().stateBuilder().value(JSONOptions.EMIT_CLICK_URL_HTTPS, Boolean.TRUE).value(JSONOptions.EMIT_RGB, Boolean.FALSE).value(JSONOptions.EMIT_HOVER_EVENT_TYPE, JSONOptions.HoverEventValueMode.VALUE_FIELD).value(JSONOptions.EMIT_CLICK_EVENT_TYPE, JSONOptions.ClickEventValueMode.CAMEL_CASE).value(JSONOptions.EMIT_COMPACT_TEXT_COMPONENT, Boolean.FALSE).value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, Boolean.FALSE).value(JSONOptions.VALIDATE_STRICT_EVENTS, Boolean.FALSE).value(JSONOptions.EMIT_CHANGE_PAGE_CLICK_EVENT_PAGE_AS_STRING, Boolean.TRUE).build()).build();
        PRE_1_20_3_SERIALIZER = GsonComponentSerializer.builder().legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).options(OptionSchema.globalSchema().stateBuilder().value(JSONOptions.EMIT_CLICK_URL_HTTPS, Boolean.TRUE).value(JSONOptions.EMIT_RGB, Boolean.TRUE).value(JSONOptions.EMIT_HOVER_EVENT_TYPE, JSONOptions.HoverEventValueMode.CAMEL_CASE).value(JSONOptions.EMIT_CLICK_EVENT_TYPE, JSONOptions.ClickEventValueMode.CAMEL_CASE).value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_KEY_AS_TYPE_AND_UUID_AS_ID, true).value(JSONOptions.EMIT_COMPACT_TEXT_COMPONENT, Boolean.FALSE).value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, Boolean.FALSE).value(JSONOptions.VALIDATE_STRICT_EVENTS, Boolean.FALSE).value(JSONOptions.EMIT_CHANGE_PAGE_CLICK_EVENT_PAGE_AS_STRING, Boolean.TRUE).build()).build();
        PRE_1_21_5_SERIALIZER = GsonComponentSerializer.builder().legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).options(OptionSchema.globalSchema().stateBuilder().value(JSONOptions.EMIT_CLICK_URL_HTTPS, Boolean.TRUE).value(JSONOptions.EMIT_RGB, Boolean.TRUE).value(JSONOptions.EMIT_HOVER_EVENT_TYPE, JSONOptions.HoverEventValueMode.CAMEL_CASE).value(JSONOptions.EMIT_CLICK_EVENT_TYPE, JSONOptions.ClickEventValueMode.CAMEL_CASE).value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_KEY_AS_TYPE_AND_UUID_AS_ID, true).value(JSONOptions.EMIT_COMPACT_TEXT_COMPONENT, Boolean.TRUE).value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, Boolean.TRUE).value(JSONOptions.VALIDATE_STRICT_EVENTS, Boolean.TRUE).value(JSONOptions.EMIT_CHANGE_PAGE_CLICK_EVENT_PAGE_AS_STRING, Boolean.TRUE).build()).build();
        MODERN_SERIALIZER = GsonComponentSerializer.builder().legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).options(OptionSchema.globalSchema().stateBuilder().value(JSONOptions.EMIT_CLICK_URL_HTTPS, Boolean.TRUE).value(JSONOptions.EMIT_RGB, Boolean.TRUE).value(JSONOptions.EMIT_HOVER_EVENT_TYPE, JSONOptions.HoverEventValueMode.SNAKE_CASE).value(JSONOptions.EMIT_CLICK_EVENT_TYPE, JSONOptions.ClickEventValueMode.SNAKE_CASE).value(JSONOptions.EMIT_COMPACT_TEXT_COMPONENT, Boolean.TRUE).value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, Boolean.TRUE).value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_KEY_AS_TYPE_AND_UUID_AS_ID, Boolean.FALSE).value(JSONOptions.VALIDATE_STRICT_EVENTS, Boolean.TRUE).value(JSONOptions.EMIT_CHANGE_PAGE_CLICK_EVENT_PAGE_AS_STRING, Boolean.FALSE).build()).build();
        BINARY_TAG_TYPES = new BinaryTagType[]{BinaryTagTypes.END, BinaryTagTypes.BYTE, BinaryTagTypes.SHORT, BinaryTagTypes.INT, BinaryTagTypes.LONG, BinaryTagTypes.FLOAT, BinaryTagTypes.DOUBLE, BinaryTagTypes.BYTE_ARRAY, BinaryTagTypes.STRING, BinaryTagTypes.LIST, BinaryTagTypes.COMPOUND, BinaryTagTypes.INT_ARRAY, BinaryTagTypes.LONG_ARRAY};
        BAD_VARINT_CACHED = new QuietDecoderException("Bad VarInt decoded");
        VAR_INT_LENGTHS = new int[33];
        for (int i = 0; i <= 32; ++i) {
            ProtocolUtils.VAR_INT_LENGTHS[i] = (int)Math.ceil((31.0 - (double)(i - 1)) / 7.0);
        }
        ProtocolUtils.VAR_INT_LENGTHS[32] = 1;
    }

    public static enum Direction {
        SERVERBOUND,
        CLIENTBOUND;

    }
}

