/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClosestLocaleMatcher {
    public static final ClosestLocaleMatcher INSTANCE = new ClosestLocaleMatcher();
    private final Map<String, Locale> byLanguage = new ConcurrentHashMap<String, Locale>();
    private final LoadingCache<Locale, Locale> closest = Caffeine.newBuilder().build(sublocale -> {
        String tag = sublocale.getLanguage();
        return this.byLanguage.getOrDefault(tag, (Locale)sublocale);
    });

    private ClosestLocaleMatcher() {
    }

    public void registerKnown(Locale locale) {
        if (locale.getLanguage().equals(new Locale("zh").getLanguage())) {
            return;
        }
        this.byLanguage.put(locale.getLanguage(), locale);
    }

    public Locale lookupClosest(Locale locale) {
        return this.closest.get(locale);
    }
}

