/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.backend;

import com.velocitypowered.api.event.player.CookieRequestEvent;
import com.velocitypowered.api.event.player.ServerLoginPluginMessageEvent;
import com.velocitypowered.api.event.player.configuration.PlayerEnteredConfigurationEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.config.PlayerInfoForwarding;
import com.velocitypowered.proxy.config.VelocityConfiguration;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.PlayerDataForwarding;
import com.velocitypowered.proxy.connection.backend.ConfigSessionHandler;
import com.velocitypowered.proxy.connection.backend.TransitionSessionHandler;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ClientPlaySessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.util.ConnectionRequestResults;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.ClientboundCookieRequestPacket;
import com.velocitypowered.proxy.protocol.packet.ClientboundStoreCookiePacket;
import com.velocitypowered.proxy.protocol.packet.DisconnectPacket;
import com.velocitypowered.proxy.protocol.packet.EncryptionRequestPacket;
import com.velocitypowered.proxy.protocol.packet.LoginAcknowledgedPacket;
import com.velocitypowered.proxy.protocol.packet.LoginPluginMessagePacket;
import com.velocitypowered.proxy.protocol.packet.LoginPluginResponsePacket;
import com.velocitypowered.proxy.protocol.packet.ServerLoginSuccessPacket;
import com.velocitypowered.proxy.protocol.packet.SetCompressionPacket;
import com.velocitypowered.proxy.util.except.QuietRuntimeException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoginSessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(LoginSessionHandler.class);
    private static final Component MODERN_IP_FORWARDING_FAILURE = Component.translatable("velocity.error.modern-forwarding-failed");
    private final VelocityServer server;
    private final VelocityServerConnection serverConn;
    private final CompletableFuture<ConnectionRequestResults.Impl> resultFuture;
    private boolean informationForwarded;

    LoginSessionHandler(VelocityServer server, VelocityServerConnection serverConn, CompletableFuture<ConnectionRequestResults.Impl> resultFuture) {
        this.server = server;
        this.serverConn = serverConn;
        this.resultFuture = resultFuture;
    }

    @Override
    public boolean handle(EncryptionRequestPacket packet) {
        throw new IllegalStateException("Backend server is online-mode!");
    }

    @Override
    public boolean handle(LoginPluginMessagePacket packet) {
        MinecraftConnection mc = this.serverConn.ensureConnected();
        VelocityConfiguration configuration = this.server.getConfiguration();
        if (configuration.getPlayerInfoForwardingMode() == PlayerInfoForwarding.MODERN && packet.getChannel().equals("velocity:player_info")) {
            byte requestedForwardingVersion = 1;
            if (packet.content().readableBytes() == 1) {
                requestedForwardingVersion = packet.content().readByte();
            }
            ConnectedPlayer player = this.serverConn.getPlayer();
            ByteBuf forwardingData = PlayerDataForwarding.createForwardingData(configuration.getForwardingSecret(), this.serverConn.getPlayerRemoteAddressAsString(), player.getProtocolVersion(), player.getGameProfile(), player.getIdentifiedKey(), requestedForwardingVersion);
            LoginPluginResponsePacket response = new LoginPluginResponsePacket(packet.getId(), true, forwardingData);
            mc.write(response);
            this.informationForwarded = true;
        } else {
            if (!this.server.getEventManager().hasSubscribers(ServerLoginPluginMessageEvent.class)) {
                mc.write(new LoginPluginResponsePacket(packet.getId(), false, Unpooled.EMPTY_BUFFER));
                return true;
            }
            byte[] contents = ByteBufUtil.getBytes(packet.content());
            MinecraftChannelIdentifier identifier = MinecraftChannelIdentifier.from(packet.getChannel());
            this.server.getEventManager().fire(new ServerLoginPluginMessageEvent(this.serverConn, identifier, contents, packet.getId())).thenAcceptAsync(event -> {
                if (event.getResult().isAllowed()) {
                    mc.write(new LoginPluginResponsePacket(packet.getId(), true, Unpooled.wrappedBuffer(event.getResult().getResponse())));
                } else {
                    mc.write(new LoginPluginResponsePacket(packet.getId(), false, Unpooled.EMPTY_BUFFER));
                }
            }, (Executor)mc.eventLoop());
        }
        return true;
    }

    @Override
    public boolean handle(DisconnectPacket packet) {
        this.resultFuture.complete(ConnectionRequestResults.forDisconnect(packet, (RegisteredServer)this.serverConn.getServer()));
        this.serverConn.disconnect();
        return true;
    }

    @Override
    public boolean handle(SetCompressionPacket packet) {
        this.serverConn.ensureConnected().setCompressionThreshold(packet.getThreshold());
        return true;
    }

    @Override
    public boolean handle(ServerLoginSuccessPacket packet) {
        if (this.server.getConfiguration().getPlayerInfoForwardingMode() == PlayerInfoForwarding.MODERN && !this.informationForwarded) {
            this.resultFuture.complete(ConnectionRequestResults.forDisconnect(MODERN_IP_FORWARDING_FAILURE, (RegisteredServer)this.serverConn.getServer()));
            this.serverConn.disconnect();
            return true;
        }
        MinecraftConnection smc = this.serverConn.ensureConnected();
        if (smc.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
            smc.setActiveSessionHandler(StateRegistry.PLAY, new TransitionSessionHandler(this.server, this.serverConn, this.resultFuture));
        } else {
            MinecraftSessionHandler minecraftSessionHandler;
            smc.write(new LoginAcknowledgedPacket());
            smc.setActiveSessionHandler(StateRegistry.CONFIG, new ConfigSessionHandler(this.server, this.serverConn, this.resultFuture));
            ConnectedPlayer player = this.serverConn.getPlayer();
            if (player.getClientSettingsPacket() != null) {
                smc.write(player.getClientSettingsPacket());
            }
            if ((minecraftSessionHandler = player.getConnection().getActiveSessionHandler()) instanceof ClientPlaySessionHandler) {
                ClientPlaySessionHandler clientPlaySessionHandler = (ClientPlaySessionHandler)minecraftSessionHandler;
                smc.setAutoReading(false);
                clientPlaySessionHandler.doSwitch().thenAcceptAsync(unused -> smc.setAutoReading(true), (Executor)smc.eventLoop());
            } else {
                this.server.getEventManager().fireAndForget(new PlayerEnteredConfigurationEvent(player, this.serverConn));
            }
        }
        return true;
    }

    @Override
    public boolean handle(ClientboundStoreCookiePacket packet) {
        throw new IllegalStateException("Can only store cookie in CONFIGURATION or PLAY protocol");
    }

    @Override
    public boolean handle(ClientboundCookieRequestPacket packet) {
        this.server.getEventManager().fire(new CookieRequestEvent(this.serverConn.getPlayer(), packet.getKey())).thenAcceptAsync(event -> {
            if (event.getResult().isAllowed()) {
                Key resultedKey = event.getResult().getKey() == null ? event.getOriginalKey() : event.getResult().getKey();
                this.serverConn.getPlayer().getConnection().write(new ClientboundCookieRequestPacket(resultedKey));
            }
        }, (Executor)this.serverConn.ensureConnected().eventLoop());
        return true;
    }

    @Override
    public void exception(Throwable throwable) {
        this.resultFuture.completeExceptionally(throwable);
    }

    @Override
    public void disconnected() {
        if (this.server.getConfiguration().getPlayerInfoForwardingMode() == PlayerInfoForwarding.LEGACY) {
            this.resultFuture.completeExceptionally(new QuietRuntimeException("The connection to the remote server was unexpectedly closed.\nThis is usually because the remote server does not have BungeeCord IP forwarding correctly enabled.\nSee https://docs.papermc.io/velocity/player-information-forwarding for instructions on how to configure player info forwarding correctly."));
        } else {
            this.resultFuture.completeExceptionally(new QuietRuntimeException("The connection to the remote server was unexpectedly closed."));
        }
    }
}

