/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StatusResponsePacket
implements MinecraftPacket {
    private @Nullable CharSequence status;

    public StatusResponsePacket() {
    }

    public StatusResponsePacket(CharSequence status) {
        this.status = status;
    }

    public String getStatus() {
        if (this.status == null) {
            throw new IllegalStateException("Status is not specified");
        }
        return this.status.toString();
    }

    public String toString() {
        return "StatusResponse{status='" + String.valueOf(this.status) + "'}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.status = ProtocolUtils.readString(buf, Short.MAX_VALUE);
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (this.status == null) {
            throw new IllegalStateException("Status is not specified");
        }
        ProtocolUtils.writeString(buf, this.status);
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

