/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.config.migration;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.velocitypowered.proxy.config.VelocityConfiguration;
import com.velocitypowered.proxy.config.migration.ConfigurationMigration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.Logger;

public final class ForwardingMigration
implements ConfigurationMigration {
    @Override
    public boolean shouldMigrate(CommentedFileConfig config) {
        return this.configVersion(config) < 2.0;
    }

    @Override
    public void migrate(CommentedFileConfig config, Logger logger) throws IOException {
        logger.warn("You are currently using a deprecated configuration version.\nThe \"forwarding-secret\"  parameter is a security hazard and was removed in config version 2.0.\nWe will migrate your secret to the \"forwarding.secret\" file.");
        String actualSecret = (String)config.get("forwarding-secret");
        Path path = Path.of(config.getOrElse("forwarding-secret-file", "forwarding.secret"), new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            String fileContents = Files.readString(path);
            if (fileContents.isBlank()) {
                Files.writeString(path, (CharSequence)(actualSecret == null ? VelocityConfiguration.generateRandomString(12) : actualSecret), new OpenOption[0]);
            }
        } else {
            Files.createFile(path, new FileAttribute[0]);
            Files.writeString(path, (CharSequence)(actualSecret == null ? VelocityConfiguration.generateRandomString(12) : actualSecret), new OpenOption[0]);
        }
        if (actualSecret != null) {
            config.remove("forwarding-secret");
        }
        config.set("forwarding-secret-file", (Object)"forwarding.secret");
        config.setComment("forwarding-secret-file", "If you are using modern or BungeeGuard IP forwarding, configure a file that contains a unique secret here.\nThe file is expected to be UTF-8 encoded and not empty.");
        config.set("config-version", (Object)"2.0");
    }
}

