/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.player.bossbar;

import com.velocitypowered.proxy.adventure.VelocityBossBarImplementation;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.BossBarPacket;
import java.util.HashSet;
import java.util.Set;

public final class BossBarManager {
    private final ConnectedPlayer player;
    private final Set<VelocityBossBarImplementation> bossBars = new HashSet<VelocityBossBarImplementation>();
    private boolean dropPackets = false;

    public BossBarManager(ConnectedPlayer player) {
        this.player = player;
    }

    public synchronized void writeUpdate(VelocityBossBarImplementation bar, BossBarPacket packet) {
        this.bossBars.add(bar);
        if (!this.dropPackets) {
            this.player.getConnection().write(packet);
        }
    }

    public synchronized void remove(VelocityBossBarImplementation bar, BossBarPacket packet) {
        this.bossBars.remove(bar);
        if (!this.dropPackets) {
            this.player.getConnection().write(packet);
        }
    }

    public synchronized void sendBossBars() {
        for (VelocityBossBarImplementation bossBar : this.bossBars) {
            bossBar.createDirect(this.player);
        }
        this.dropPackets = false;
    }

    public synchronized void dropPackets() {
        this.dropPackets = true;
    }
}

