/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.connection.ConnectionHandshakeEvent;
import com.velocitypowered.api.network.HandshakeIntent;
import com.velocitypowered.api.network.ProtocolState;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.config.PlayerInfoForwarding;
import com.velocitypowered.proxy.connection.ConnectionType;
import com.velocitypowered.proxy.connection.ConnectionTypes;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.client.InitialInboundConnection;
import com.velocitypowered.proxy.connection.client.InitialLoginSessionHandler;
import com.velocitypowered.proxy.connection.client.LoginInboundConnection;
import com.velocitypowered.proxy.connection.client.StatusSessionHandler;
import com.velocitypowered.proxy.connection.forge.modern.ModernForgeConnectionType;
import com.velocitypowered.proxy.connection.util.VelocityInboundConnection;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.HandshakePacket;
import com.velocitypowered.proxy.protocol.packet.LegacyDisconnect;
import com.velocitypowered.proxy.protocol.packet.LegacyHandshakePacket;
import com.velocitypowered.proxy.protocol.packet.LegacyPingPacket;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.translation.Argument;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HandshakeSessionHandler
implements MinecraftSessionHandler {
    private static final Logger LOGGER = LogManager.getLogger(HandshakeSessionHandler.class);
    private final MinecraftConnection connection;
    private final VelocityServer server;

    public HandshakeSessionHandler(MinecraftConnection connection, VelocityServer server) {
        this.connection = Preconditions.checkNotNull(connection, "connection");
        this.server = Preconditions.checkNotNull(server, "server");
    }

    @Override
    public boolean handle(LegacyPingPacket packet) {
        this.connection.setProtocolVersion(ProtocolVersion.LEGACY);
        StatusSessionHandler handler = new StatusSessionHandler(this.server, new LegacyInboundConnection(this.connection, packet));
        this.connection.setActiveSessionHandler(StateRegistry.STATUS, handler);
        handler.handle(packet);
        return true;
    }

    @Override
    public boolean handle(LegacyHandshakePacket packet) {
        this.connection.closeWith(LegacyDisconnect.from(Component.text("Your client is extremely old. Please update to a newer version of Minecraft.", (TextColor)NamedTextColor.RED)));
        return true;
    }

    @Override
    public boolean handle(HandshakePacket handshake) {
        StateRegistry nextState = HandshakeSessionHandler.getStateForProtocol(handshake.getNextStatus());
        if (nextState == null) {
            LOGGER.error("{} provided invalid protocol {}", (Object)this, (Object)handshake.getNextStatus());
            this.connection.close(true);
        } else {
            InitialInboundConnection ic = new InitialInboundConnection(this.connection, HandshakeSessionHandler.cleanVhost(handshake.getServerAddress()), handshake);
            if (handshake.getIntent() == HandshakeIntent.TRANSFER && !this.server.getConfiguration().isAcceptTransfers()) {
                ic.disconnect(Component.translatable("multiplayer.disconnect.transfers_disabled"));
                return true;
            }
            this.connection.setProtocolVersion(handshake.getProtocolVersion());
            this.connection.setAssociation(ic);
            switch (nextState) {
                case STATUS: {
                    this.connection.setActiveSessionHandler(StateRegistry.STATUS, new StatusSessionHandler(this.server, ic));
                    break;
                }
                case LOGIN: {
                    this.handleLogin(handshake, ic);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"getStateForProtocol provided invalid state!");
                }
            }
        }
        return true;
    }

    private static @Nullable StateRegistry getStateForProtocol(int status) {
        return switch (status) {
            case 1 -> StateRegistry.STATUS;
            case 2, 3 -> StateRegistry.LOGIN;
            default -> null;
        };
    }

    private void handleLogin(HandshakePacket handshake, InitialInboundConnection ic) {
        if (!handshake.getProtocolVersion().isSupported()) {
            this.connection.setState(StateRegistry.LOGIN);
            ic.disconnectQuietly((Component)Component.translatable().key("multiplayer.disconnect.outdated_client").arguments(Argument.string("versions", ProtocolVersion.SUPPORTED_VERSION_STRING)).build());
            return;
        }
        InetAddress address = ((InetSocketAddress)this.connection.getRemoteAddress()).getAddress();
        if (!this.server.getIpAttemptLimiter().attempt(address)) {
            this.connection.setState(StateRegistry.LOGIN);
            ic.disconnectQuietly(Component.translatable("velocity.error.logging-in-too-fast"));
            return;
        }
        this.connection.setType(this.getHandshakeConnectionType(handshake));
        if (this.server.getConfiguration().getPlayerInfoForwardingMode() == PlayerInfoForwarding.MODERN && handshake.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_13)) {
            this.connection.setState(StateRegistry.LOGIN);
            ic.disconnectQuietly(Component.translatable("velocity.error.modern-forwarding-needs-new-client"));
            return;
        }
        LoginInboundConnection lic = new LoginInboundConnection(ic);
        this.server.getEventManager().fireAndForget(new ConnectionHandshakeEvent(lic, handshake.getIntent()));
        this.connection.setActiveSessionHandler(StateRegistry.LOGIN, new InitialLoginSessionHandler(this.server, this.connection, lic));
    }

    private ConnectionType getHandshakeConnectionType(HandshakePacket handshake) {
        if (handshake.getServerAddress().contains("FORGE") && handshake.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
            return new ModernForgeConnectionType(handshake.getServerAddress());
        }
        if (handshake.getServerAddress().endsWith("\u0000FML\u0000") && handshake.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_13)) {
            return ConnectionTypes.LEGACY_FORGE;
        }
        if (handshake.getProtocolVersion().noGreaterThan(ProtocolVersion.MINECRAFT_1_7_6)) {
            return ConnectionTypes.UNDETERMINED_17;
        }
        return ConnectionTypes.VANILLA;
    }

    @VisibleForTesting
    static String cleanVhost(String hostname) {
        String cleaned = hostname;
        int zeroIdx = cleaned.indexOf(0);
        if (zeroIdx > -1) {
            cleaned = hostname.substring(0, zeroIdx);
        }
        if (!cleaned.isEmpty() && cleaned.charAt(cleaned.length() - 1) == '.') {
            cleaned = cleaned.substring(0, cleaned.length() - 1);
        }
        return cleaned;
    }

    @Override
    public void handleGeneric(MinecraftPacket packet) {
        this.connection.close(true);
    }

    @Override
    public void handleUnknown(ByteBuf buf) {
        this.connection.close(true);
    }

    public String toString() {
        boolean isPlayerAddressLoggingEnabled = this.connection.server.getConfiguration().isPlayerAddressLoggingEnabled();
        String playerIp = isPlayerAddressLoggingEnabled ? this.connection.getRemoteAddress().toString() : "<ip address withheld>";
        return "[initial connection] " + playerIp;
    }

    private record LegacyInboundConnection(MinecraftConnection connection, LegacyPingPacket ping) implements VelocityInboundConnection
    {
        @Override
        public InetSocketAddress getRemoteAddress() {
            return (InetSocketAddress)this.connection.getRemoteAddress();
        }

        @Override
        public Optional<InetSocketAddress> getVirtualHost() {
            return Optional.ofNullable(this.ping.getVhost());
        }

        @Override
        public Optional<String> getRawVirtualHost() {
            return this.getVirtualHost().map(InetSocketAddress::getHostName);
        }

        @Override
        public boolean isActive() {
            return !this.connection.isClosed();
        }

        @Override
        public ProtocolVersion getProtocolVersion() {
            return ProtocolVersion.LEGACY;
        }

        @Override
        public String toString() {
            boolean isPlayerAddressLoggingEnabled = this.connection.server.getConfiguration().isPlayerAddressLoggingEnabled();
            String playerIp = isPlayerAddressLoggingEnabled ? this.getRemoteAddress().toString() : "<ip address withheld>";
            return "[legacy connection] " + playerIp;
        }

        @Override
        public MinecraftConnection getConnection() {
            return this.connection;
        }

        @Override
        public ProtocolState getProtocolState() {
            return this.connection.getState().toProtocolState();
        }

        @Override
        public HandshakeIntent getHandshakeIntent() {
            return HandshakeIntent.STATUS;
        }
    }
}

