/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.text.Component;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class ComponentHolder {
    private static final Logger logger = LogManager.getLogger(ComponentHolder.class);
    public static final int DEFAULT_MAX_STRING_SIZE = 262143;
    private final ProtocolVersion version;
    private @MonotonicNonNull Component component;
    private @MonotonicNonNull String json;
    private @MonotonicNonNull BinaryTag binaryTag;

    public ComponentHolder(ProtocolVersion version, Component component) {
        this.version = version;
        this.component = component;
    }

    public ComponentHolder(ProtocolVersion version, String json) {
        this.version = version;
        this.json = json;
    }

    public ComponentHolder(ProtocolVersion version, BinaryTag binaryTag) {
        this.version = version;
        this.binaryTag = binaryTag;
    }

    public Component getComponent() {
        if (this.component == null) {
            if (this.json != null) {
                this.component = ProtocolUtils.getJsonChatSerializer(this.version).deserialize(this.json);
            } else if (this.binaryTag != null) {
                try {
                    this.json = ComponentHolder.deserialize(this.binaryTag).toString();
                    this.component = ProtocolUtils.getJsonChatSerializer(this.version).deserialize(this.json);
                }
                catch (Exception ex) {
                    logger.error("Error converting binary component to JSON component! Binary: " + String.valueOf(this.binaryTag) + " JSON: " + this.json, (Throwable)ex);
                    throw ex;
                }
            }
        }
        return this.component;
    }

    public String getJson() {
        if (this.json == null) {
            this.json = (String)ProtocolUtils.getJsonChatSerializer(this.version).serialize(this.getComponent());
        }
        return this.json;
    }

    public BinaryTag getBinaryTag() {
        if (this.binaryTag == null) {
            this.binaryTag = ComponentHolder.serialize(ProtocolUtils.getJsonChatSerializer(this.version).serializeToTree(this.getComponent()));
        }
        return this.binaryTag;
    }

    public static BinaryTag serialize(JsonElement json) {
        if (json instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)json;
            if (jsonPrimitive.isNumber()) {
                Number number;
                Number number2 = number = json.getAsNumber();
                Objects.requireNonNull(number2);
                Number number3 = number2;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, LazilyParsedNumber.class}, (Object)number3, n)) {
                    case 0 -> {
                        Byte b = (Byte)number3;
                        yield ByteBinaryTag.byteBinaryTag(b);
                    }
                    case 1 -> {
                        Short s = (Short)number3;
                        yield ShortBinaryTag.shortBinaryTag(s);
                    }
                    case 2 -> {
                        Integer i = (Integer)number3;
                        yield IntBinaryTag.intBinaryTag(i);
                    }
                    case 3 -> {
                        Long l = (Long)number3;
                        yield LongBinaryTag.longBinaryTag(l);
                    }
                    case 4 -> {
                        Float f = (Float)number3;
                        yield FloatBinaryTag.floatBinaryTag(f.floatValue());
                    }
                    case 5 -> {
                        Double d = (Double)number3;
                        yield DoubleBinaryTag.doubleBinaryTag(d);
                    }
                    case 6 -> {
                        LazilyParsedNumber l = (LazilyParsedNumber)number3;
                        yield IntBinaryTag.intBinaryTag(l.intValue());
                    }
                    default -> throw new IllegalArgumentException("Unknown number type: " + String.valueOf(number));
                };
            }
            if (jsonPrimitive.isString()) {
                return StringBinaryTag.stringBinaryTag(jsonPrimitive.getAsString());
            }
            if (jsonPrimitive.isBoolean()) {
                return ByteBinaryTag.byteBinaryTag((byte)(jsonPrimitive.getAsBoolean() ? 1 : 0));
            }
            throw new IllegalArgumentException("Unknown JSON primitive: " + String.valueOf(jsonPrimitive));
        }
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            CompoundBinaryTag.Builder compound = CompoundBinaryTag.builder();
            for (Map.Entry<String, JsonElement> property : object.entrySet()) {
                compound.put(property.getKey(), ComponentHolder.serialize(property.getValue()));
            }
            return compound.build();
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            List<JsonElement> jsonArray = array.asList();
            if (jsonArray.isEmpty()) {
                return ListBinaryTag.empty();
            }
            ArrayList<BinaryTag> tagItems = new ArrayList<BinaryTag>(jsonArray.size());
            BinaryTagType<? extends BinaryTag> listType = null;
            for (JsonElement jsonEl : jsonArray) {
                BinaryTag tag2 = ComponentHolder.serialize(jsonEl);
                tagItems.add(tag2);
                if (listType == null) {
                    listType = tag2.type();
                    continue;
                }
                if (listType == tag2.type()) continue;
                listType = BinaryTagTypes.COMPOUND;
            }
            switch (listType.id()) {
                case 1: {
                    byte[] bytes = new byte[jsonArray.size()];
                    for (int i = 0; i < bytes.length; ++i) {
                        bytes[i] = jsonArray.get(i).getAsNumber().byteValue();
                    }
                    return ByteArrayBinaryTag.byteArrayBinaryTag(bytes);
                }
                case 3: {
                    int[] ints = new int[jsonArray.size()];
                    for (int i = 0; i < ints.length; ++i) {
                        ints[i] = jsonArray.get(i).getAsNumber().intValue();
                    }
                    return IntArrayBinaryTag.intArrayBinaryTag(ints);
                }
                case 4: {
                    long[] longs = new long[jsonArray.size()];
                    for (int i = 0; i < longs.length; ++i) {
                        longs[i] = jsonArray.get(i).getAsNumber().longValue();
                    }
                    return LongArrayBinaryTag.longArrayBinaryTag(longs);
                }
                case 10: {
                    tagItems.replaceAll(tag -> {
                        if (tag.type() == BinaryTagTypes.COMPOUND) {
                            return tag;
                        }
                        return ((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("", (BinaryTag)tag)).build();
                    });
                }
            }
            return ListBinaryTag.listBinaryTag(listType, tagItems);
        }
        return EndBinaryTag.endBinaryTag();
    }

    public static JsonElement deserialize(BinaryTag tag) {
        return switch (tag.type().id()) {
            case 1 -> new JsonPrimitive(((ByteBinaryTag)tag).value());
            case 2 -> new JsonPrimitive(((ShortBinaryTag)tag).value());
            case 3 -> new JsonPrimitive(((IntBinaryTag)tag).value());
            case 4 -> new JsonPrimitive(((LongBinaryTag)tag).value());
            case 5 -> new JsonPrimitive(Float.valueOf(((FloatBinaryTag)tag).value()));
            case 6 -> new JsonPrimitive(((DoubleBinaryTag)tag).value());
            case 7 -> {
                byte[] byteArray = ((ByteArrayBinaryTag)tag).value();
                JsonArray jsonByteArray = new JsonArray(byteArray.length);
                for (byte b : byteArray) {
                    jsonByteArray.add(new JsonPrimitive(b));
                }
                yield jsonByteArray;
            }
            case 8 -> new JsonPrimitive(((StringBinaryTag)tag).value());
            case 9 -> {
                ListBinaryTag items = (ListBinaryTag)tag;
                JsonArray jsonList = new JsonArray(items.size());
                for (BinaryTag subTag : items) {
                    jsonList.add(ComponentHolder.deserialize(subTag));
                }
                yield jsonList;
            }
            case 10 -> {
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                JsonObject jsonObject = new JsonObject();
                compound.keySet().forEach(key -> jsonObject.add(key.isEmpty() ? "text" : key, ComponentHolder.deserialize(compound.get((String)key))));
                yield jsonObject;
            }
            case 11 -> {
                int[] intArray = ((IntArrayBinaryTag)tag).value();
                JsonArray jsonIntArray = new JsonArray(intArray.length);
                for (int i : intArray) {
                    jsonIntArray.add(new JsonPrimitive(i));
                }
                yield jsonIntArray;
            }
            case 12 -> {
                long[] longArray = ((LongArrayBinaryTag)tag).value();
                JsonArray jsonLongArray = new JsonArray(longArray.length);
                for (long l : longArray) {
                    jsonLongArray.add(new JsonPrimitive(l));
                }
                yield jsonLongArray;
            }
            default -> throw new IllegalArgumentException("Unknown NBT tag: " + String.valueOf(tag));
        };
    }

    public static ComponentHolder read(ByteBuf buf, ProtocolVersion version) {
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_3)) {
            return new ComponentHolder(version, ProtocolUtils.readBinaryTag(buf, version, BinaryTagIO.reader()));
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_13)) {
            return new ComponentHolder(version, ProtocolUtils.readString(buf, 262143));
        }
        return new ComponentHolder(version, ProtocolUtils.readString(buf));
    }

    public void write(ByteBuf buf) {
        if (this.version.noLessThan(ProtocolVersion.MINECRAFT_1_20_3)) {
            ProtocolUtils.writeBinaryTag(buf, this.version, this.getBinaryTag());
        } else {
            ProtocolUtils.writeString(buf, this.getJson());
        }
    }
}

