/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.BungeeCordMessageResponder;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InitialConnectSessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(InitialConnectSessionHandler.class);
    private final ConnectedPlayer player;
    private final VelocityServer server;

    InitialConnectSessionHandler(ConnectedPlayer player, VelocityServer server) {
        this.player = player;
        this.server = server;
    }

    @Override
    public boolean handle(PluginMessagePacket packet) {
        VelocityServerConnection serverConn = this.player.getConnectionInFlight();
        if (serverConn != null) {
            if (this.player.getPhase().handle(this.player, packet, serverConn)) {
                return true;
            }
            if (BungeeCordMessageResponder.isBungeeCordMessage(packet)) {
                return true;
            }
            ChannelIdentifier id = this.server.getChannelRegistrar().getFromId(packet.getChannel());
            if (id == null) {
                serverConn.ensureConnected().write(packet.retain());
                return true;
            }
            byte[] copy = ByteBufUtil.getBytes(packet.content());
            PluginMessageEvent event = new PluginMessageEvent(serverConn, serverConn.getPlayer(), id, copy);
            ((CompletableFuture)this.server.getEventManager().fire(event).thenAcceptAsync(pme -> {
                if (pme.getResult().isAllowed() && serverConn.isActive()) {
                    PluginMessagePacket copied = new PluginMessagePacket(packet.getChannel(), Unpooled.wrappedBuffer(copy));
                    serverConn.ensureConnected().write(copied);
                }
            }, (Executor)this.player.getConnection().eventLoop())).exceptionally(ex -> {
                logger.error("Exception while handling plugin message {}", (Object)packet, ex);
                return null;
            });
        }
        return true;
    }

    @Override
    public void disconnected() {
        this.player.teardown();
    }
}

