/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.player.resourcepack.handler;

import com.velocitypowered.api.event.player.PlayerResourcePackStatusEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.player.resourcepack.ResourcePackResponseBundle;
import com.velocitypowered.proxy.connection.player.resourcepack.handler.Legacy117ResourcePackHandler;
import com.velocitypowered.proxy.connection.player.resourcepack.handler.ResourcePackHandler;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public sealed class LegacyResourcePackHandler
extends ResourcePackHandler
permits Legacy117ResourcePackHandler {
    protected @MonotonicNonNull Boolean previousResourceResponse;
    protected final Queue<ResourcePackInfo> outstandingResourcePacks = new ArrayDeque<ResourcePackInfo>();
    private @Nullable ResourcePackInfo pendingResourcePack;
    private @Nullable ResourcePackInfo appliedResourcePack;

    LegacyResourcePackHandler(ConnectedPlayer player, VelocityServer server) {
        super(player, server);
    }

    @Override
    public @Nullable ResourcePackInfo getFirstAppliedPack() {
        return this.appliedResourcePack;
    }

    @Override
    public @Nullable ResourcePackInfo getFirstPendingPack() {
        return this.pendingResourcePack;
    }

    @Override
    @NotNull
    public Collection<ResourcePackInfo> getAppliedResourcePacks() {
        if (this.appliedResourcePack == null) {
            return List.of();
        }
        return List.of(this.appliedResourcePack);
    }

    @Override
    @NotNull
    public Collection<ResourcePackInfo> getPendingResourcePacks() {
        if (this.pendingResourcePack == null) {
            return List.of();
        }
        return List.of(this.pendingResourcePack);
    }

    @Override
    public void clearAppliedResourcePacks() {
        this.appliedResourcePack = null;
    }

    @Override
    public boolean remove(@NotNull UUID id) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot remove a ResourcePack from a legacy client");
    }

    @Override
    public void queueResourcePack(@NotNull ResourcePackInfo info) {
        this.outstandingResourcePacks.add(info);
        if (this.outstandingResourcePacks.size() == 1) {
            this.tickResourcePackQueue();
        }
    }

    private void tickResourcePackQueue() {
        ResourcePackInfo queued = this.outstandingResourcePacks.peek();
        if (queued != null) {
            if (this.previousResourceResponse != null && !this.previousResourceResponse.booleanValue()) {
                while (!(this.outstandingResourcePacks.isEmpty() || (queued = this.outstandingResourcePacks.peek()).getShouldForce() && this.player.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_17))) {
                    this.onResourcePackResponse(new ResourcePackResponseBundle(queued.getId(), queued.getHash() == null ? "" : new String(queued.getHash()), PlayerResourcePackStatusEvent.Status.DECLINED));
                    queued = null;
                }
                if (queued == null) {
                    return;
                }
            }
            this.sendResourcePackRequestPacket(queued);
        }
    }

    @Override
    public boolean onResourcePackResponse(@NotNull ResourcePackResponseBundle bundle) {
        boolean peek = bundle.status().isIntermediate();
        ResourcePackInfo queued = peek ? this.outstandingResourcePacks.peek() : this.outstandingResourcePacks.poll();
        this.server.getEventManager().fire(new PlayerResourcePackStatusEvent(this.player, bundle.uuid(), bundle.status(), queued)).thenAcceptAsync(event -> {
            if (this.shouldDisconnectForForcePack((PlayerResourcePackStatusEvent)event)) {
                event.getPlayer().disconnect(Component.translatable("multiplayer.requiredTexturePrompt.disconnect"));
            }
        });
        switch (bundle.status()) {
            case ACCEPTED: {
                this.previousResourceResponse = true;
                this.pendingResourcePack = queued;
                break;
            }
            case DECLINED: {
                this.previousResourceResponse = false;
                break;
            }
            case SUCCESSFUL: {
                this.appliedResourcePack = queued;
                this.pendingResourcePack = null;
                break;
            }
            case FAILED_DOWNLOAD: {
                this.pendingResourcePack = null;
                break;
            }
            case DISCARDED: {
                if (queued == null || queued.getId() == null || this.appliedResourcePack == null || !this.appliedResourcePack.getId().equals(queued.getId())) break;
                this.appliedResourcePack = null;
                break;
            }
        }
        if (!peek) {
            this.player.getConnection().eventLoop().execute(this::tickResourcePackQueue);
        }
        return this.handleResponseResult(queued, bundle);
    }

    @Override
    public boolean hasPackAppliedByHash(byte[] hash) {
        if (hash == null) {
            return false;
        }
        return this.appliedResourcePack != null && Arrays.equals(this.appliedResourcePack.getHash(), hash);
    }

    protected boolean shouldDisconnectForForcePack(PlayerResourcePackStatusEvent event) {
        return event.getStatus() == PlayerResourcePackStatusEvent.Status.DECLINED && event.getPackInfo() != null && event.getPackInfo().getShouldForce();
    }
}

