/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.network.netty;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultNameResolver;
import io.netty.resolver.InetNameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public final class SeparatePoolInetNameResolver
extends InetNameResolver {
    private final ExecutorService resolveExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Velocity DNS Resolver").setDaemon(true).build());
    private final InetNameResolver delegate;
    private final Cache<String, List<InetAddress>> cache;
    private AddressResolverGroup<InetSocketAddress> resolverGroup;

    public SeparatePoolInetNameResolver(EventExecutor executor) {
        super(executor);
        this.delegate = new DefaultNameResolver(executor);
        this.cache = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    }

    @Override
    protected void doResolve(String inetHost, Promise<InetAddress> promise) throws Exception {
        List<InetAddress> addresses = this.cache.getIfPresent(inetHost);
        if (addresses != null) {
            promise.trySuccess(addresses.getFirst());
            return;
        }
        try {
            this.resolveExecutor.execute(() -> {
                promise.addListener(future -> {
                    if (future.isSuccess()) {
                        this.cache.put(inetHost, ImmutableList.of((InetAddress)future.getNow()));
                    }
                });
                this.delegate.resolve(inetHost, promise);
            });
        }
        catch (RejectedExecutionException e) {
            promise.setFailure(e);
        }
    }

    @Override
    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) throws Exception {
        List<InetAddress> addresses = this.cache.getIfPresent(inetHost);
        if (addresses != null) {
            promise.trySuccess(addresses);
            return;
        }
        try {
            promise.addListener(future -> {
                if (future.isSuccess()) {
                    this.cache.put(inetHost, (List)future.getNow());
                }
            });
            this.resolveExecutor.execute(() -> this.delegate.resolveAll(inetHost, promise));
        }
        catch (RejectedExecutionException e) {
            promise.setFailure(e);
        }
    }

    public void shutdown() {
        this.resolveExecutor.shutdown();
    }

    public AddressResolverGroup<InetSocketAddress> asGroup() {
        if (this.resolverGroup == null) {
            this.resolverGroup = new AddressResolverGroup<InetSocketAddress>(){

                @Override
                protected AddressResolver<InetSocketAddress> newResolver(EventExecutor executor) {
                    return SeparatePoolInetNameResolver.this.asAddressResolver();
                }
            };
        }
        return this.resolverGroup;
    }
}

