/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.plugin.loader;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class VelocityPluginContainer
implements PluginContainer {
    private final PluginDescription description;
    private Object instance;
    private volatile ExecutorService service;

    public VelocityPluginContainer(PluginDescription description) {
        this.description = description;
    }

    @Override
    public PluginDescription getDescription() {
        return this.description;
    }

    @Override
    public Optional<?> getInstance() {
        return Optional.ofNullable(this.instance);
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService getExecutorService() {
        if (this.service == null) {
            VelocityPluginContainer velocityPluginContainer = this;
            synchronized (velocityPluginContainer) {
                if (this.service == null) {
                    String name = this.description.getName().orElse(this.description.getId());
                    this.service = Executors.unconfigurableExecutorService(Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(name + " - Task Executor #%d").setDaemon(true).build()));
                }
            }
        }
        return this.service;
    }

    public boolean hasExecutorService() {
        return this.service != null;
    }
}

