/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.netty;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class PlayPacketQueueOutboundHandler
extends ChannelDuplexHandler {
    private final StateRegistry.PacketRegistry.ProtocolRegistry registry;
    private final Queue<MinecraftPacket> queue = new ArrayDeque<MinecraftPacket>();

    public PlayPacketQueueOutboundHandler(ProtocolVersion version, ProtocolUtils.Direction direction) {
        this.registry = StateRegistry.CONFIG.getProtocolRegistry(direction, version);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof MinecraftPacket)) {
            ctx.write(msg, promise);
            return;
        }
        MinecraftPacket packet = (MinecraftPacket)msg;
        if (this.registry.containsPacket(packet)) {
            ctx.write(msg, promise);
            return;
        }
        this.queue.offer(packet);
    }

    @Override
    public void channelInactive(@NotNull ChannelHandlerContext ctx) throws Exception {
        this.releaseQueue(ctx, false);
        super.channelInactive(ctx);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.releaseQueue(ctx, ctx.channel().isActive());
    }

    private void releaseQueue(ChannelHandlerContext ctx, boolean active) {
        MinecraftPacket packet;
        while ((packet = this.queue.poll()) != null) {
            if (active) {
                ctx.write(packet, ctx.voidPromise());
                continue;
            }
            ReferenceCountUtil.release(packet);
        }
        if (active) {
            ctx.flush();
        }
    }
}

