/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.kyori.adventure.sound.Sound;
import org.jetbrains.annotations.Nullable;

public class ClientboundSoundEntityPacket
implements MinecraftPacket {
    private static final Random SEEDS_RANDOM = new Random();
    private Sound sound;
    @Nullable
    private Float fixedRange;
    private int emitterEntityId;

    public ClientboundSoundEntityPacket() {
    }

    public ClientboundSoundEntityPacket(Sound sound, @Nullable Float fixedRange, int emitterEntityId) {
        this.sound = sound;
        this.fixedRange = fixedRange;
        this.emitterEntityId = emitterEntityId;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException("Decode is not implemented");
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeVarInt(buf, 0);
        ProtocolUtils.writeMinimalKey(buf, this.sound.name());
        buf.writeBoolean(this.fixedRange != null);
        if (this.fixedRange != null) {
            buf.writeFloat(this.fixedRange.floatValue());
        }
        ProtocolUtils.writeSoundSource(buf, protocolVersion, this.sound.source());
        ProtocolUtils.writeVarInt(buf, this.emitterEntityId);
        buf.writeFloat(this.sound.volume());
        buf.writeFloat(this.sound.pitch());
        buf.writeLong(this.sound.seed().orElse(SEEDS_RANDOM.nextLong()));
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public Sound getSound() {
        return this.sound;
    }

    public void setSound(Sound sound) {
        this.sound = sound;
    }

    @Nullable
    public Float getFixedRange() {
        return this.fixedRange;
    }

    public void setFixedRange(@Nullable Float fixedRange) {
        this.fixedRange = fixedRange;
    }

    public int getEmitterEntityId() {
        return this.emitterEntityId;
    }

    public void setEmitterEntityId(int emitterEntityId) {
        this.emitterEntityId = emitterEntityId;
    }
}

