/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import io.netty.buffer.ByteBuf;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DisconnectPacket
implements MinecraftPacket {
    private @Nullable ComponentHolder reason;
    private final StateRegistry state;

    public DisconnectPacket(StateRegistry state) {
        this.state = state;
    }

    private DisconnectPacket(StateRegistry state, ComponentHolder reason) {
        this.state = state;
        this.reason = Preconditions.checkNotNull(reason, "reason");
    }

    public ComponentHolder getReason() {
        if (this.reason == null) {
            throw new IllegalStateException("No reason specified");
        }
        return this.reason;
    }

    public void setReason(@Nullable ComponentHolder reason) {
        this.reason = reason;
    }

    public String toString() {
        return "Disconnect{reason='" + String.valueOf(this.reason) + "'}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.reason = ComponentHolder.read(buf, this.state == StateRegistry.LOGIN ? ProtocolVersion.MINECRAFT_1_20_2 : version);
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.getReason().write(buf);
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public static DisconnectPacket create(Component component, ProtocolVersion version, StateRegistry state) {
        Preconditions.checkNotNull(component, "component");
        return new DisconnectPacket(state, new ComponentHolder(state == StateRegistry.LOGIN ? ProtocolVersion.MINECRAFT_1_20_2 : version, component));
    }
}

