/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.brigadier;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.util.Ordered;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ArgumentIdentifier {
    private final String identifier;
    private final Map<ProtocolVersion, Integer> versionById;

    private ArgumentIdentifier(String identifier, VersionSet ... versions) {
        this.identifier = Preconditions.checkNotNull(identifier);
        Preconditions.checkNotNull(versions);
        HashMap<ProtocolVersion, Integer> temp = new HashMap<ProtocolVersion, Integer>();
        Ordered previous = null;
        for (VersionSet version : versions) {
            VersionSet current = Preconditions.checkNotNull(version);
            Preconditions.checkArgument(current.getVersion().noLessThan(ProtocolVersion.MINECRAFT_1_19), "Version too old for ID index");
            Preconditions.checkArgument(previous == null || previous.greaterThan(current.getVersion()), "Invalid protocol version order");
            for (ProtocolVersion v : ProtocolVersion.values()) {
                if (!v.noLessThan(current.getVersion())) continue;
                temp.putIfAbsent(v, current.getId());
            }
            previous = current.getVersion();
        }
        this.versionById = ImmutableMap.copyOf(temp);
    }

    public String toString() {
        return "ArgumentIdentifier{identifier='" + this.identifier + "'}";
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public @Nullable Integer getIdByProtocolVersion(ProtocolVersion version) {
        return this.versionById.get(Preconditions.checkNotNull(version));
    }

    public static VersionSet mapSet(ProtocolVersion version, int id) {
        return new VersionSet(version, id);
    }

    public static ArgumentIdentifier id(String identifier, VersionSet ... versions) {
        return new ArgumentIdentifier(identifier, versions);
    }

    public static class VersionSet {
        private final ProtocolVersion version;
        private final int id;

        private VersionSet(ProtocolVersion version, int id) {
            this.version = Preconditions.checkNotNull(version);
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public ProtocolVersion getVersion() {
            return this.version;
        }
    }
}

